package cn.com.duiba.tuia.core.api.enums;

import java.util.Map;

import com.google.common.collect.Maps;


/**
 * 
 * ClassName: AppOfflineStatusEnum <br/>
 * Function: 应用上下线状态枚举. <br/>
 * date: 2017年12月18日 下午2:05:30 <br/>
 *
 * @author chencheng
 * @version 
 * @since JDK 1.8
 */
public enum AppOfflineStatusEnum {
    /** 有效. */
    EFFECTIVE_STATUS(1,"有效"),

    /** 无效. */
    INVALID_STATUS(2,"无效"),
    
    /** 上线. */
    ONLINE_STATUS(3,"上线"),
    
    /** 下线. */
    OFFLINE_STATUS(4,"下线"),
    
    /** 屏蔽. */
    SHIELD_STATUS(5,"屏蔽");

 
    /** 代码 */
    private int code;
    /** 描述 */
    private String desc;

    private AppOfflineStatusEnum(int code, String desc){
        this.code = code;
        this.desc = desc;
    }

    private static Map<Integer, AppOfflineStatusEnum> enumMap = Maps.newHashMap();
    static {
        for (AppOfflineStatusEnum typeEnum : AppOfflineStatusEnum.values()) {
            enumMap.put(typeEnum.code, typeEnum);
        }
    }
    
    public static AppOfflineStatusEnum getByCode(Integer code){
        return enumMap.get(code);
    }

    public static String getStatusByCode(Integer code) {
        return enumMap.get(code) == null ? "" : enumMap.get(code).getDesc();
    }

    public int getCode() {
        return code;
    }


    public String getDesc() {
        return desc;
    }

}
