/**
 * Project Name:tuia-core-api<br>
 * File Name:Tag.java<br>
 * Package Name:cn.com.duiba.tuia.core.api.dto<br>
 * Date:2016年9月27日下午7:22:11<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.core.api.dto.rsp.advert;

import org.apache.commons.lang.builder.ToStringBuilder;

import cn.com.duiba.tuia.core.api.dto.BaseDto;

/**
 * ClassName: NewTagDto <br/>
 * Function: 免费券广告. <br/>
 * date: 2018年1月15日 上午11:58:34 <br/>
 *
 * @author chencheng
 * @version
 * @since JDK 1.8
 */
public class ValidFreeAdvertOrderDto extends BaseDto {

    private static final long serialVersionUID = -5645294455244711001L;

    /** 数据源id */
    private Long              sourceId;

    /** 数据源类型：advert:广告,agent:代理商 */
    private String            sourceType;

    /** 广告的代理商id */
    private Long              agentId;

    /** 排序级别;用于排序 */
    private Long              orderLevel;

    /** 级别更新时间ms数 */
    private Long              levelUpdateTime;

    /** 数据源名称 */
    private String            name;

    /**
     * name.
     *
     * @return the name
     * @since JDK 1.8
     */
    public String getName() {
        return name;
    }

    /**
     * name.
     *
     * @param name the name to set
     * @since JDK 1.8
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * sourceId.
     *
     * @return the sourceId
     * @since JDK 1.8
     */
    public Long getSourceId() {
        return sourceId;
    }

    /**
     * sourceId.
     *
     * @param sourceId the sourceId to set
     * @since JDK 1.8
     */
    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    /**
     * sourceType.
     *
     * @return the sourceType
     * @since JDK 1.8
     */
    public String getSourceType() {
        return sourceType;
    }

    /**
     * sourceType.
     *
     * @param sourceType the sourceType to set
     * @since JDK 1.8
     */
    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    /**
     * agentId.
     *
     * @return the agentId
     * @since JDK 1.8
     */
    public Long getAgentId() {
        return agentId;
    }

    /**
     * agentId.
     *
     * @param agentId the agentId to set
     * @since JDK 1.8
     */
    public void setAgentId(Long agentId) {
        this.agentId = agentId;
    }

    /**
     * orderLevel.
     *
     * @return the orderLevel
     * @since JDK 1.8
     */
    public Long getOrderLevel() {
        return orderLevel;
    }

    /**
     * orderLevel.
     *
     * @param orderLevel the orderLevel to set
     * @since JDK 1.8
     */
    public void setOrderLevel(Long orderLevel) {
        this.orderLevel = orderLevel;
    }

    /**
     * levelUpdateTime.
     *
     * @return the levelUpdateTime
     * @since JDK 1.8
     */
    public Long getLevelUpdateTime() {
        return levelUpdateTime;
    }

    /**
     * levelUpdateTime.
     *
     * @param levelUpdateTime the levelUpdateTime to set
     * @since JDK 1.8
     */
    public void setLevelUpdateTime(Long levelUpdateTime) {
        this.levelUpdateTime = levelUpdateTime;
    }

    /**
     * To string.
     *
     * @return the string
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
