package cn.com.duiba.tuia.core.api.enums;

import java.util.Map;

import com.google.common.collect.Maps;

/**
 * 
 * ClassName: AdvertSortTypeEnum <br/>
 * Function:有效广告排序缓存更新特殊值. <br/>
 * date: 2018年1月29日 下午2:51:23 <br/>
 *
 * @author chencheng
 * @version 
 * @since JDK 1.8
 */
public enum AdvertSortTypeEnum {

    /** 全部更新 */
    ALL(0L, "all"),
    
    /** 付费券缓存更新 */
    PAY(-1L, "pay"),
    
    /** 免费券缓存更新 */
    FREE(-2L, "free");

    private String desc;

    private Long code;

    AdvertSortTypeEnum(Long code, String desc) {
        this.desc = desc;
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public Long getCode() {
        return code;
    }

    private static Map<Long, AdvertSortTypeEnum> enumMap = Maps.newHashMap();
    static {
        for (AdvertSortTypeEnum it : AdvertSortTypeEnum.values()) {
            enumMap.put(it.getCode(), it);
        }
    }

    public static AdvertSortTypeEnum getByCode(Long type) {
        return enumMap.get(type);
    }

}
