/**
 * Project Name:tuia-core-api<br>
 * File Name:RoleType.java<br>
 * Package Name:cn.com.duiba.tuia.core.api.constant<br>
 * Date:2016年9月7日上午9:17:56<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.core.api.constant;

import java.util.Map;

import com.google.common.collect.Maps;

/**
 * ClassName: RoleType <br/>
 * Function: 角色类型. <br/>
 * date: 2016年9月7日 上午9:17:56 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
public enum RoleType {

    /** 投放平台管理员. */
    TUIA_ADVER_ADMIN(1),

    /** 投放平台观察员. */
    TUIA_ADVER_OBSERVER(2),

    /** 投放平台操作员. */
    TUIA_ADVER_OPERATOR(3),

    /** 投放平台财务员. */
    TUIA_ADVER_TREASURER(4);

    /** 用户类型. */
    private long role;

    private static Map<Long, RoleType> enumMap = Maps.newHashMap();
    static {
        for (RoleType it : RoleType.values()) {
            enumMap.put(it.getRoleType(), it);
        }
    }
    
    public static RoleType getByRoleType(Long roleType){
        return enumMap.get(roleType);
    }
    /**
     * Creates a new instance of RoleType.
     *
     * @param roleType
     */

    private RoleType(long roleType) {
        this.role = roleType;
    }

    public long getRoleType() {
        return role;
    }

}
