package cn.com.duiba.tuia.core.api.remoteservice.advert;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.CouponRecoveryLogDto;
import cn.com.duiba.tuia.core.api.dto.advert.req.ReqQueryCouponRecoveryLogDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * Created by huangch on 2017/8/29 19:30
 * description:
 *
 * @since JDK 1.6
 */
@AdvancedFeignClient
public interface RemoteCouponRecoveryService {

    /**
     * 插入券码回收记录. <br/>
     *
     * @param t the t
     * @return the int
     */
    DubboResult<Integer> insert(CouponRecoveryLogDto t);

    /**
     * 更新券码回收记录. <br/>
     *
     * @param id          the id
     * @param fileUrl     the file url
     * @param recoveryNum the recovery num
     * @param status      the status
     * @return the int
     */
    DubboResult<Integer> update(Long id, String fileUrl, int recoveryNum, Integer status);

    /**
     * 查询券码回收总条数.
     *
     * @param req the req
     * @return the int
     */
    DubboResult<Integer> selectLogAmount(ReqQueryCouponRecoveryLogDto req);

    /**
     * 分页查询券码回收记录.
     *
     * @param req the req
     * @return the list< coupon recovery log rsq>
     */
    DubboResult<List<CouponRecoveryLogDto>> selectLogs(ReqQueryCouponRecoveryLogDto req);

    /**
     * 查询广告指定批次的回收状态. <br/>
     *
     * @param advertId the advert id
     * @param batchId  the batch id
     * @return the integer
     */
    DubboResult<Integer> selectRecoveryStatus(Long advertId, Long batchId);
}
