/**
 * Project Name:tuia-advert-center-api
 * File Name:RemoteAdvertMaterialStatisticsService.java
 * Package Name:cn.com.duiba.tuia.core.api.remoteservice.statistics
 * Date:2017年8月26日下午4:52:46
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.core.api.remoteservice.statistics;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.statistics.domain.AdvertMaterialStatisticsRsp;
import cn.com.duiba.tuia.core.api.statistics.domain.GetAdvertMaterialStatisticsReq;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemoteAdvertMaterialStatisticsService <br/>
 * Function: 广告每小时数据实时数据查询. <br/>
 * Date:     2017年8月26日 下午4:52:46 <br/>
 * @author   chencheng
 * @version  
 * @since    JDK 1.8
 * @see 	 
 */
@AdvancedFeignClient
public interface RemoteAdvertMaterialStatisticsService {
    /**
     * countAdvertMaterialData:(广告素材维度数据总计). <br/>
     *
     * @author chencheng
     * @param req
     * @return
     * @since JDK 1.8
     */
    DubboResult<Integer> countAdvertMaterialData(GetAdvertMaterialStatisticsReq req);
    
    /**
     * selectAdvertMaterialData:(广告素材维度数据查询). <br/>
     *
     * @author chencheng
     * @param req
     * @return
     * @since JDK 1.8
     */
    DubboResult<List<AdvertMaterialStatisticsRsp>> selectAdvertMaterialData(GetAdvertMaterialStatisticsReq req);
    
}

