package cn.com.duiba.tuia.core.api.remoteservice.slot;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.rsp.slot.SlotDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * Created by jzl on 18/4/2.
 */
@AdvancedFeignClient
public interface RemoteSlotService {

    /**
     * 查询广告位集合信息
     */
    DubboResult<List<SlotDto>> getSlotsByAppId(Long appId);

    /**
     * 查询单个广告位信息
     * @param slotId
     * @return
     */
    DubboResult<SlotDto> selectBySlotId(Long slotId);

    /**
     * 插入广告位表
     * @param slotDto
     */
    void insertSlot(SlotDto slotDto);

    /**
     * 更新广告位的福袋开启关闭 0-关闭 1-开启
     * @param slotId
     * @param isSendLuckybag
     * @return
     */
    Integer updateSendLuckybag(Long slotId, Integer isSendLuckybag);
    
    /**
     * 
     * updateSortType:(更新广告位白名单排序开关：0-人工，1-arup值). <br/>
     *
     * @author chencheng
     * @param slotId
     * @param sortType
     * @return
     * @since JDK 1.8
     */
    Integer updateSortType(Long slotId, Integer sortType);

    /**
     * 修改标签－－跟随App的
     * @param slotDto
     */
    void updateSlotBannedTag(SlotDto slotDto);
}
