package cn.com.duiba.tuia.core.api.dto.rsp;

import java.util.Date;

import org.apache.commons.lang.builder.ToStringBuilder;

import cn.com.duiba.tuia.core.api.dto.BaseDto;

/**
 * 此实体类对应tuia_adver库中的表为:
 * 	tb_advert_coupon_percent
 * 	tb_advert_click_percent
 * @version 
 * @since JDK 1.6
 */
public class RspAdvertCouponPercent extends BaseDto {

	private static final long serialVersionUID = -8982035067497788443L;
	
	/** 类型:1-平台;2-地域;3-时段;4-设备价格;5-发券次序;6-媒体ID;7-出价区间 */
	private Integer type; 
	
	/** 区间 */
	private Integer interval;
	
	/** 总发券 */
	private Long totalCoupon;
	
	/** 发券流量占比(1表示100%) */
	private Double couponPercent;
	
	/** 总点击 */
	private Long totalClick;
	
	/** 点击流量占比 */
	private Double clickPercent;
	
	/** 广告计划数  */
	private Long orderNum;
	
	/** 当前日期 */
	private Date curDate;

	public Integer getType() {
		return type;
	}

	public void setType(Integer type) {
		this.type = type;
	}

	public Integer getInterval() {
		return interval;
	}

	public void setInterval(Integer interval) {
		this.interval = interval;
	}

	public Long getTotalCoupon() {
		return totalCoupon;
	}

	public void setTotalCoupon(Long totalCoupon) {
		this.totalCoupon = totalCoupon;
	}

	public Double getCouponPercent() {
		return couponPercent;
	}

	public void setCouponPercent(double couponPercent) {
		this.couponPercent = couponPercent;
	}

	public Long getTotalClick() {
		return totalClick;
	}

	public void setTotalClick(Long totalClick) {
		this.totalClick = totalClick;
	}

	public Double getClickPercent() {
		return clickPercent;
	}

	public void setClickPercent(double clickPercent) {
		this.clickPercent = clickPercent;
	}

	public Long getOrderNum() {
		return orderNum;
	}

	public void setOrderNum(Long orderNum) {
		this.orderNum = orderNum;
	}

	public Date getCurDate() {
		return curDate;
	}

	public void setCurDate(Date curDate) {
		this.curDate = curDate;
	}
	
	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this);
	}

}
