/**
 * Project Name:tuia-core-api<br>
 * File Name:RspRecharge.java<br>
 * Package Name:cn.com.duiba.tuia.core.api.dto.rsp<br>
 * Date:2016年9月5日上午9:33:52<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.core.api.dto.rsp;

import java.io.Serializable;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ClassName: RspRecharge <br/>
 * Function: 充值结果相应. <br/>
 * date: 2016年9月5日 上午9:33:52 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
public class RspRecharge implements Serializable {

    /** The Constant serialVersionUID. */
    private static final long serialVersionUID = 1L;

    /** 邮箱. */
    private String            email;

    /** 联系人. */
    private String            linkman;

    /** 数量. */
    private Long              amount;

    /**
     * The Constructor.
     */
    public RspRecharge() {
        super();
    }

    /**
     * The Constructor.
     *
     * @param email the email
     * @param linkman the linkman
     * @param amount the amount
     */
    public RspRecharge(String email, String linkman, Long amount) {
        super();
        this.email = email;
        this.linkman = linkman;
        this.amount = amount;
    }

    /**
     * Gets the email.
     *
     * @return the email
     */
    public String getEmail() {
        return email;
    }

    /**
     * Sets the email.
     *
     * @param email the email
     */
    public void setEmail(String email) {
        this.email = email;
    }

    /**
     * Gets the linkman.
     *
     * @return the linkman
     */
    public String getLinkman() {
        return linkman;
    }

    /**
     * Sets the linkman.
     *
     * @param linkman the linkman
     */
    public void setLinkman(String linkman) {
        this.linkman = linkman;
    }

    /**
     * Gets the amount.
     *
     * @return the amount
     */
    public Long getAmount() {
        return amount;
    }

    /**
     * Sets the amount.
     *
     * @param amount the amount
     */
    public void setAmount(Long amount) {
        this.amount = amount;
    }

    /**
     * To string.
     *
     * @return the string
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
