/**
 * Project Name:tuia-core-api<br>
 * File Name:AdvertMaterialDto.java<br>
 * Package Name:cn.com.duiba.tuia.core.api.dto<br>
 * Date:2016年12月21日下午2:11:03<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.core.api.dto;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * 广告素材媒体关联DTO <br/>
 * date: 2016年12月21日 下午2:11:03 <br/>
 * .
 *
 * @author youhaijun
 * @version
 * @since JDK 1.7
 */
public class AdvertMaterialAppRelationDto extends BaseDto {

    /** The Constant serialVersionUID. @since JDK 1.7 */
    private static final long serialVersionUID = 4460714964755511436L;

    /** 默认按钮文案. */

    /** 新素材. */
    public static final int   IS_NEW           = 1;

    /** 老素材. */
    public static final int   IS_OLD           = 0;

    /** 删除状态. */
    public static final int   IS_DELETE        = 1;

    /** 非删除态. */
    public static final int   IS_NOT_DELETE    = 0;

    /** 素材ID. */
    private Long              materialId;

    /** 媒体ID. */
    private Long              appId;

    /** 默认状态(0：老素材， 1：新素材). */
    private Integer           isNew;

    /** 删除状态(0：未删除， 1：已删除). */
    private Integer           isDeleted;

    /**
     * Gets the is deleted.
     *
     * @return the checks if is deleted
     */
    public Integer getIsDeleted() {
        return isDeleted;
    }

    /**
     * Sets the is deleted.
     *
     * @param isDeleted the checks if is deleted
     */
    public void setIsDeleted(Integer isDeleted) {
        this.isDeleted = isDeleted;
    }

    /**
     * To string.
     *
     * @return the string
     */
    @Override
    public String toString() {

        return ToStringBuilder.reflectionToString(this);
    }

    /**
     * Gets the material id.
     *
     * @return the material id
     */
    public Long getMaterialId() {
        return materialId;
    }

    /**
     * Sets the material id.
     *
     * @param materialId the material id
     */
    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    /**
     * Gets the app id.
     *
     * @return the app id
     */
    public Long getAppId() {
        return appId;
    }

    /**
     * Sets the app id.
     *
     * @param appId the app id
     */
    public void setAppId(Long appId) {
        this.appId = appId;
    }

    /**
     * Gets the is new.
     *
     * @return the checks if is new
     */
    public Integer getIsNew() {
        return isNew;
    }

    /**
     * Sets the is new.
     *
     * @param isNew the checks if is new
     */
    public void setIsNew(Integer isNew) {
        this.isNew = isNew;
    }

}
