/**
 * Project Name:tuia-advert-center-api File Name:ReqAdvertBudgetDayHourHistioryDto.java Package
 * Name:cn.com.duiba.tuia.core.api.dto.req Date:2017年8月24日下午3:05:58 Copyright (c) 2017, duiba.com.cn All Rights
 * Reserved.
 */

package cn.com.duiba.tuia.core.api.dto.req.advert;

import java.util.Date;
import java.util.List;

import org.apache.commons.lang.builder.ToStringBuilder;

import cn.com.duiba.tuia.core.api.dto.BaseQueryDateReq;

/**
 * ClassName:ReqAdvertBudgetDayHourHistioryDto <br/>
 * Function: 每日每小时广告状态、预算记录请求参数. <br/>
 * Date: 2017年8月24日 下午3:05:58 <br/>
 * 
 * @author chencheng
 * @version
 * @since JDK 1.8
 * @see
 */
public class ReqAdvertBudgetDayHourHistioryDto extends BaseQueryDateReq {

    private static final long serialVersionUID = -816182541149732576L;

    /** 广告id集合 */
    private List<Long>        advertIds;

    /** 广告id */
    private Long              advertId;

    /** 日期. */
    private Date              curDate;

    /**
     * curDate.
     *
     * @return the curDate
     * @since JDK 1.8
     */
    public Date getCurDate() {
        return curDate;
    }

    /**
     * curDate.
     *
     * @param curDate the curDate to set
     * @since JDK 1.8
     */
    public void setCurDate(Date curDate) {
        this.curDate = curDate;
    }

    /**
     * advertId.
     *
     * @return the advertId
     * @since JDK 1.8
     */
    public Long getAdvertId() {
        return advertId;
    }

    /**
     * advertId.
     *
     * @param advertId the advertId to set
     * @since JDK 1.8
     */
    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    /**
     * advertIds.
     *
     * @return the advertIds
     * @since JDK 1.8
     */
    public List<Long> getAdvertIds() {
        return advertIds;
    }

    /**
     * advertIds.
     *
     * @param advertIds the advertIds to set
     * @since JDK 1.8
     */
    public void setAdvertIds(List<Long> advertIds) {
        this.advertIds = advertIds;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
