package cn.com.duiba.tuia.core.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.PageDto;
import cn.com.duiba.tuia.core.api.dto.PhoneLibraryDto;

/**
 * @author: panaihua
 * @date: 2017年02月22日 15:08
 * @descript:
 * @version: 1.0
 */
@AdvancedFeignClient
public interface RemotePhoneLibraryService {

    /**
     * 分页获取手机信息
     * @param phoneType
     * @param priceStatus
     * @return
     */
    PageDto<PhoneLibraryDto> getPhoneByConditions(Integer currentPage, Integer pageSize, String phoneType, Integer priceStatus);

    PageDto<PhoneLibraryDto> getPhoneByConditionNew(Integer currentPage, Integer pageSize, String phoneType, Integer priceStatus, String brandName);


    /**
     * 更新手机信息
     * @param phoneId
     * @param phoneLevel
     * @return
     */
    int updatePhoneLevel(Long phoneId,String phoneLevel);
}
