/**
 * Project Name:tuia-advert-center-api
 * File Name:TradeTagRuleDto.java
 * Package Name:cn.com.duiba.tuia.core.api.dto.rsp.tradeTagRule
 * Date:2018年3月21日上午11:25:42
 * Copyright (c) 2018, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.core.api.dto.rsp.tradeTagRule;

import cn.com.duiba.tuia.core.api.dto.BaseDto;

/**
 * ClassName:TradeTagRuleDto <br/>
 * Function: 行业规则兴趣值. <br/>
 * Date:     2018年3月21日 上午11:25:42 <br/>
 * @author   chencheng
 * @version  
 * @since    JDK 1.8
 * @see 	 
 */
public class TradeTagRuleDto extends BaseDto {
    
    private static final long serialVersionUID = -3867758190199218505L;

    /** 标签tagNum */
    private String            tagNum;

    /** 点击感兴趣的最小阈值 */
    private Integer           clickInterestedMin;

    /** 点击感兴趣的最大阈值 */
    private Integer           clickInterestedMax;

    /** 转化感兴趣的最小阈值 */
    private Integer           effectInterestedMin;

    /** 转化感兴趣的最大阈值 */
    private Integer           effectInterestedMax;

    /** 点击不感兴趣的最小阈值 */
    private Integer           clickNoInterestedMin;

    /** 点击不感兴趣的最大阈值 */
    private Integer           clickNoInterestedMax;

    /** 转化不感兴趣的最小分值 */
    private Integer           effectNoInterestedMin;

    /** 转化不感兴趣的最大分值 */
    private Integer           effectNoInterestedMax;

    /** 标签等级:1-一级标签，2-二级标签 */
    private Integer           tagLevel;

    /**
     * tagNum.
     *
     * @return the tagNum
     * @since JDK 1.8
     */
    public String getTagNum() {
        return tagNum;
    }

    /**
     * tagNum.
     *
     * @param tagNum the tagNum to set
     * @since JDK 1.8
     */
    public void setTagNum(String tagNum) {
        this.tagNum = tagNum;
    }

    /**
     * tagLevel.
     *
     * @return the tagLevel
     * @since JDK 1.8
     */
    public Integer getTagLevel() {
        return tagLevel;
    }

    /**
     * tagLevel.
     *
     * @param tagLevel the tagLevel to set
     * @since JDK 1.8
     */
    public void setTagLevel(Integer tagLevel) {
        this.tagLevel = tagLevel;
    }

    public Integer getClickInterestedMin() {
        return clickInterestedMin;
    }

    public void setClickInterestedMin(Integer clickInterestedMin) {
        this.clickInterestedMin = clickInterestedMin;
    }

    public Integer getClickInterestedMax() {
        return clickInterestedMax;
    }

    public void setClickInterestedMax(Integer clickInterestedMax) {
        this.clickInterestedMax = clickInterestedMax;
    }

    public Integer getEffectInterestedMin() {
        return effectInterestedMin;
    }

    public void setEffectInterestedMin(Integer effectInterestedMin) {
        this.effectInterestedMin = effectInterestedMin;
    }

    public Integer getEffectInterestedMax() {
        return effectInterestedMax;
    }

    public void setEffectInterestedMax(Integer effectInterestedMax) {
        this.effectInterestedMax = effectInterestedMax;
    }

    public Integer getClickNoInterestedMin() {
        return clickNoInterestedMin;
    }

    public void setClickNoInterestedMin(Integer clickNoInterestedMin) {
        this.clickNoInterestedMin = clickNoInterestedMin;
    }

    public Integer getClickNoInterestedMax() {
        return clickNoInterestedMax;
    }

    public void setClickNoInterestedMax(Integer clickNoInterestedMax) {
        this.clickNoInterestedMax = clickNoInterestedMax;
    }

    public Integer getEffectNoInterestedMin() {
        return effectNoInterestedMin;
    }

    public void setEffectNoInterestedMin(Integer effectNoInterestedMin) {
        this.effectNoInterestedMin = effectNoInterestedMin;
    }

    public Integer getEffectNoInterestedMax() {
        return effectNoInterestedMax;
    }

    public void setEffectNoInterestedMax(Integer effectNoInterestedMax) {
        this.effectNoInterestedMax = effectNoInterestedMax;
    }
}

