package cn.com.duiba.tuia.core.api.remoteservice.advertiser;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.boot.netflix.feign.hystrix.FeignHystrixProperty;
import cn.com.duiba.boot.netflix.feign.hystrix.conf.HystrixPropertiesManager;
import cn.com.duiba.tuia.core.api.dto.advertiser.AccountFinanceStatisticsDayDto;
import cn.com.duiba.tuia.core.api.dto.finance.BalanceRecordSummaryDataDto;
import cn.com.duiba.tuia.core.api.dto.finance.ConsumeRecordSummaryDataDto;
import cn.com.duiba.tuia.core.api.dto.finance.FinanceReconciliationSearchConditionDto;
import cn.com.duiba.tuia.core.api.dto.finance.ReconciliationDataResponse;
import cn.com.duiba.tuia.core.api.dto.req.account.AccountFinanceStatisticsQueryDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by huangch on 2017/8/21 15:47 description: 财务记录每日统计汇总服务
 *
 * @since JDK 1.6
 */
@AdvancedFeignClient
public interface RemoteAccountFinanceStatisticsDayService {

    /**
     * 添加财务记录每日统计汇总记录
     *
     * @param accountFinanceStatisticsDay 所有参数均为必传
     * @return
     */
    DubboResult<Integer> addAccountFinanceStatisticsDay(AccountFinanceStatisticsDayDto accountFinanceStatisticsDay);

    /**
     * 查询财务记录每日统计汇总记录
     *
     * @param accountId 代理商或者广告主id 必传
     * @param type 交易类型:(10：账号充值; 11:平台退款; 12:代理商划账; 13:赠送金额; 14:线上充值;20:广告扣费; 21: 扣除金额; 22:代理商划账) 必传
     * @return
     */
    DubboResult<AccountFinanceStatisticsDayDto> getFinanceStatisticsDay(Long accountId, int type);

    /**
     * @param accountId         代理商或者广告主id 必传
     * @param type              交易类型:(10：账号充值; 11:平台退款; 12:代理商划账; 13:赠送金额; 14:线上充值;20:广告扣费; 21: 扣除金额; 22:代理商划账) 必传
     * @param effectiveMainType 生效的主体类型，1-杭州推啊，2-霍尔果斯推啊，默认1
     * @return
     */
    List<AccountFinanceStatisticsDayDto> getMainTypeFinanceStatisticsDay(Long accountId, int type, Integer effectiveMainType);

    /**
     * 更新财务记录每日统计汇总记录
     *
     * @param accountFinanceStatisticsDay curDate、accountId和type必传
     * @return
     */
    DubboResult<Integer> updateFinanceStatisticsDay(AccountFinanceStatisticsDayDto accountFinanceStatisticsDay);

    List<AccountFinanceStatisticsDayDto> list(AccountFinanceStatisticsQueryDto queryDto);

    List<AccountFinanceStatisticsDayDto> gatherList(AccountFinanceStatisticsQueryDto queryDto);

    /**
     * 查询统计消费记录的汇总数据
     *
     * @param queryDto 查询参数
     * @return 现金、返货消费金额统计
     */
    ConsumeRecordSummaryDataDto selectConsumeRecordSummaryData(AccountFinanceStatisticsQueryDto queryDto);

    List<Long> queryAccountIds(AccountFinanceStatisticsQueryDto queryDto);

    /**
     * 查询余额记录的汇总数据
     */
    BalanceRecordSummaryDataDto selectBalanceRecordSummaryData(AccountFinanceStatisticsQueryDto queryDto);

    int count(AccountFinanceStatisticsQueryDto queryDto);

    ReconciliationDataResponse getReconciliationData(FinanceReconciliationSearchConditionDto searchCondition);

    /**
     * 导出财务对账数据
     * @param searchConditionDto
     * @return
     */
    @FeignHystrixProperty(name= HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value="30000")
    ReconciliationDataResponse exportReconciliationData(FinanceReconciliationSearchConditionDto searchConditionDto);
}
