/**
 * Project Name:tuia-advert-center-api File Name:RemoteTagUserCountService.java Package
 * Name:cn.com.duiba.tuia.core.api.remoteservice.tagUserCount Date:2018年3月21日下午5:55:13 Copyright (c) 2018, duiba.com.cn
 * All Rights Reserved.
 */

package cn.com.duiba.tuia.core.api.remoteservice.tagUserCount;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.req.tagUserCount.TagUserCountReq;
import cn.com.duiba.tuia.core.api.dto.rsp.tagUserCount.TagUserCountDto;

/**
 * ClassName:RemoteTagUserCountService <br/>
 * Function: 标签对应的用户接受度人群查询接口. <br/>
 * Date: 2018年3月21日 下午5:55:13 <br/>
 * 
 * @author chencheng
 * @version
 * @since JDK 1.8
 * @see
 */
@AdvancedFeignClient
public interface RemoteTagUserCountService {

    /**
     * selectTagUserCount:(根据标签查询标签对应的用户接受度人群). <br/>
     *
     * @author chencheng
     * @param entity
     * @return
     * @since JDK 1.8
     */
    List<TagUserCountDto> selectTagUserCount(TagUserCountReq req);
}
