/**
 * Project Name:tuia-core-api<br>
 * File Name:ReqGetAllAdvertIdsOfAdvertiserDto.java<br>
 * Package Name:cn.com.duiba.tuia.core.api.dto.req<br>
 * Date:2016年11月4日下午3:07:32<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.core.api.dto.req;

import cn.com.duiba.tuia.core.api.statistics.domain.BaseQueryReq;
import org.apache.commons.lang.builder.ToStringBuilder;

import java.io.Serializable;
import java.util.List;

/**
 * ClassName: ReqGetAllAdvertIdsOfAdvertiserDto <br/>
 * Function: 查询广告ID列表请求参数. <br/>
 * date: 2016年11月4日 下午3:07:32 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
public class ReqGetAdvertIds extends BaseQueryReq implements Serializable {

    /** The Constant serialVersionUID. */
    private static final long serialVersionUID = 2825867512546281030L;

    /** 审核状态. */
    private Integer           checkStatus;

    /** 广告名称. */
    private String            name;

    /** 广告主账号id. */
    private Long              accountId;

    //广告类型
    private Integer advertType;

    /** 广告有效状态. */
    private Integer           validStatus;

    /** 邮箱. */
    private String            email;

    /** 公司名称. */
    private String            companyName;

    /** 代理商ID. */
    private Long              agentId;

    /** 角色ID. */
    private Long              roleId;

    /** 用户类型. */
    private Integer           userType;

    /** The ader ids. */
    private List<Long>        aderIds;

    /**
     * The Constructor.
     *
     * @param checkStatus the check status
     * @param name the name
     * @param accountId the account id
     * @param validStatus the valid status
     */
    public ReqGetAdvertIds(Integer checkStatus, String name, Long accountId, Integer validStatus) {
        super();
        this.checkStatus = checkStatus;
        this.name = name;
        this.accountId = accountId;
        this.validStatus = validStatus;
    }

    /**
     * Creates a new instance of ReqGetAdvertIds.
     *
     * @param checkStatus the check status
     * @param name the name
     * @param accountId the account id
     * @param validStatus the valid status
     * @param email the email
     * @param companyName the company name
     * @param agentId the agent id
     */

    public ReqGetAdvertIds(Integer checkStatus, String name, Long accountId, Integer validStatus, String email,
                           String companyName, Long agentId) {
        super();
        this.checkStatus = checkStatus;
        this.name = name;
        this.accountId = accountId;
        this.validStatus = validStatus;
        this.email = email;
        this.companyName = companyName;
        this.agentId = agentId;
    }

    public Integer getAdvertType() {
        return advertType;
    }

    public void setAdvertType(Integer advertType) {
        this.advertType = advertType;
    }

    /**
     * The Constructor.
     */
    public ReqGetAdvertIds() {
        super();
    }

    /**
     * Gets the check status.
     *
     * @return the check status
     */
    public Integer getCheckStatus() {
        return checkStatus;
    }

    /**
     * Sets the check status.
     *
     * @param checkStatus the check status
     */
    public void setCheckStatus(Integer checkStatus) {
        this.checkStatus = checkStatus;
    }

    /**
     * Gets the name.
     *
     * @return the name
     */
    public String getName() {
        return name;
    }

    /**
     * Sets the name.
     *
     * @param name the name
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * Gets the account id.
     *
     * @return the account id
     */
    public Long getAccountId() {
        return accountId;
    }

    /**
     * Sets the account id.
     *
     * @param accountId the account id
     */
    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    /**
     * Gets the valid status.
     *
     * @return the valid status
     */
    public Integer getValidStatus() {
        return validStatus;
    }

    /**
     * Sets the valid status.
     *
     * @param validStatus the valid status
     */
    public void setValidStatus(Integer validStatus) {
        this.validStatus = validStatus;
    }

    /**
     * Gets the email.
     *
     * @return the email
     */
    public String getEmail() {
        return email;
    }

    /**
     * Sets the email.
     *
     * @param email the email
     */
    public void setEmail(String email) {
        this.email = email;
    }

    /**
     * Gets the company name.
     *
     * @return the company name
     */
    public String getCompanyName() {
        return companyName;
    }

    /**
     * Sets the company name.
     *
     * @param companyName the company name
     */
    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    /**
     * Gets the agent id.
     *
     * @return the agent id
     */
    public Long getAgentId() {
        return agentId;
    }

    /**
     * Sets the agent id.
     *
     * @param agentId the agent id
     */
    public void setAgentId(Long agentId) {
        this.agentId = agentId;
    }

    /**
     * Gets the role id.
     *
     * @return the role id
     */
    public Long getRoleId() {
        return roleId;
    }

    /**
     * Sets the role id.
     *
     * @param roleId the role id
     */
    public void setRoleId(Long roleId) {
        this.roleId = roleId;
    }

    /**
     * Gets the user type.
     *
     * @return the user type
     */
    public Integer getUserType() {
        return userType;
    }

    /**
     * Sets the user type.
     *
     * @param userType the user type
     */
    public void setUserType(Integer userType) {
        this.userType = userType;
    }

    /**
     * Gets the ader ids.
     *
     * @return the ader ids
     */
    public List<Long> getAderIds() {
        return aderIds;
    }

    /**
     * Sets the ader ids.
     *
     * @param aderIds the ader ids
     */
    public void setAderIds(List<Long> aderIds) {
        this.aderIds = aderIds;
    }

    /**
     * To string.
     *
     * @return the string
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
