package cn.com.duiba.tuia.core.api.enums.advert;

import java.util.Map;

import com.google.common.collect.Maps;

/**
 * ClassName: AdvertValidStatusEnum <br/>
 * Function: 广告有效状态枚举. <br/>
 * date: 2017年8月22日 下午7:11:05 <br/>
 *
 * @author chencheng
 * @version
 */
public enum AdvertValidStatusEnum {

    /** 无效(兑吧广告)状态 */
    INVALID_DUIBA(0, "无效(兑吧广告)状态"),

    /** 有效状态. */
    VALID_STATUS(1, "有效状态"),

    /** 无效(暂停)状态. */
    INVALID_SUSPEND(2, "无效(暂停)状态"),

    /** 无效(审核中)状态. */
    INVALID_CHECK_IN(3, "无效(审核中)状态"),

    /** 无效(审核拒绝)状态. */
    INVALID_CHECK_REFUSE(4, "无效(审核拒绝)状态"),

    /** 无效(账号余额不足)状态. */
    INVALID_BALANCE_NOT_ENOUGH(5, "无效(账号余额不足)状态"),

    /** 无效(账号预算不足)状态. */
    INVALID_BALANCE_BUDGET_SHORTFALL(6, "无效(账号预算不足)状态"),

    /** 无效(广告预算不足)状态. */
    INVALID_ADVERT_BUDGET_SHORTFALL(7, "无效(广告预算不足)状态"),

    /** 无效(库存不足)状态. */
    INVALID_INADEQUATE_INVENTORY(8, "无效(库存不足)状态"),

    /** 无效(非投放日期)状态. */
    INVALID_NON_DELIVERY_DATE(9, "无效(非投放日期)状态"),

    /** 无效(优惠码失效)状态. */
    INVALID(10, "无效(优惠码失效)状态"),

    INVALID_LAND_PAGE_CHECK_REFUSE(11, "无效(落地页审核被拒绝)状态");

    private String  desc;

    private Integer code;

    AdvertValidStatusEnum(Integer code, String desc) {
        this.desc = desc;
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }

    private static Map<Integer, AdvertValidStatusEnum> enumMap = Maps.newHashMap();
    static {
        for (AdvertValidStatusEnum it : AdvertValidStatusEnum.values()) {
            enumMap.put(it.getCode(), it);
        }
    }

    public static AdvertValidStatusEnum getByName(Integer code) {
        return enumMap.get(code);
    }
}
