package cn.com.duiba.tuia.core.api.remoteservice.resourceTags;

import java.util.List;
import java.util.Map;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.resourceTags.ResourceTagsDto;
import cn.com.duiba.tuia.core.api.enums.ResourceTagsTypeEnum;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * 
 * ClassName: RemoteResourceTagsService <br/>
 * Function: 资源标签列表. <br/>
 * date: 2017年8月1日 下午4:10:21 <br/>
 *
 * @author chencheng
 * @version
 */
@AdvancedFeignClient
public interface RemoteResourceTagsService {

    /**
     * 根据id和类型查询标签信息
     *
     * @author chencheng
     * @param resoureId
     * @param resoureType
     * @return
     */
    DubboResult<ResourceTagsDto> selectResourceTagsById(Long resourceId, ResourceTagsTypeEnum resoureType);
    
    /**
     * 根据id集合 和类型查询标签信息
     *
     * @author chencheng
     * @param resourceIds
     * @param resoureType
     * @return
     */
    DubboResult<List<ResourceTagsDto>> selectResourceTagsByIds(List<Long> resourceIds, ResourceTagsTypeEnum resoureType);
    
    /**
     * 根据广告id查询广告默认素材，推广链接标签信息
     *
     * @author chencheng
     * @param advertId
     * @return
     */
    Map<String, List<ResourceTagsDto>> selectResourceTagsByAdvertId(Long advertId) throws BizException;
    
    /**
     * 新增资源的标签信息
     *
     * @author chencheng
     * @param dto
     * @return
     */
    DubboResult<Integer> insetResourceTags(ResourceTagsDto dto);
    
    /**
     * 更新资源的标签信息
     *
     * @author chencheng
     * @param dto
     * @return
     */
    DubboResult<Integer> updateResourceTags(ResourceTagsDto dto);

    /**
     * 更新或插入资源的标签信息
     *
     * @author chencheng
     * @param dto
     * @return
     */
    DubboResult<Integer> updateOrInsertResourceTags(ResourceTagsDto dto);
    
    /**
     * 更新或插入资源的标签集合信息
     *
     * @author chencheng
     * @param list
     * @return
     */
    DubboResult<Integer> updateOrInsertList(List<ResourceTagsDto> list);
    
    /**
     * 
     * selectResourceTagsByType:(根据类型查询资源). <br/>
     *
     * @author chencheng
     * @param type
     * @return
     * @throws TuiaCoreException
     * @since JDK 1.8
     */
    List<ResourceTagsDto> selectResourceTagsByType(String type);
    
    /**
     * 
     * batchInsetResourceTags:(批量插入). <br/>
     *
     * @author chencheng
     * @param list
     * @return
     * @since JDK 1.8
     */
    Integer batchInsetResourceTags(List<ResourceTagsDto> list);
    
    /**
     * 
     * batchUpdateResourceTags:(批量更新). <br/>
     *
     * @author chencheng
     * @param list
     * @return
     * @since JDK 1.8
     */
    Integer batchUpdateResourceTags(List<ResourceTagsDto> list);
}
