package cn.com.duiba.tuia.core.api.dto.media;

import cn.com.duiba.tuia.core.api.dto.BaseDto;
import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * @author zhangmeng
 * @function 提供广告在媒体投放信息实体类
 * @date 2018.09.19
 */
public class MediaAppInfoDto extends BaseDto {

    private static final long serialVersionUID = -7849491668042935314L;
    //媒体id
    private Long appId;
    //广告id
    private Long advertId;
    //广告名称
    private String advertName;
    //广告对应的二级行业标签
    private String advertTag;
    //ae名称
    private String aeName;
    //广告每日预算
    private String advertBudgetPerDay;
    /**
     * 广告状态
     暂停状态0
    有效状态1
    无效(暂停)状态2
    无效(审核中)状态3
    无效(审核拒绝)状态4
    无效(账号余额不足)状态5
    无效(账号预算不足)状态6
    无效(广告预算不足)状态7
    无效(库存不足)状态.8
    无效(非投放日期)状态.9
    无效(优惠码失效)状态.10
    无效(落地页审核被拒绝)状态.11
     */
    private Integer advertValidStatus;
    //配置id
    private Long orientPackageId;
    //配置预算
    private Long orientBudgetPerDay;
    //配置的出价 cpc -fee,cpa-a_fee (配置出价最终存放在这里)
    private Long fee;
    //配置转化出价
    private Long aFee;
    //配置状态
    private Integer orientEnableStatus;
    //广告类型 1:互动广告，2:展示广告
    private Integer advertType;
    //配置计费方式 1:cpc 2:cpa
    private Integer chargeType;
    //是否是默认 1：默认配置，0：非默认配置
    private Integer isDefault;



    public MediaAppInfoDto() {
    }

    public Long getaFee() {
        return aFee;
    }

    public void setaFee(Long aFee) {
        this.aFee = aFee;
    }

    public Integer getChargeType() {
        return chargeType;
    }

    public void setChargeType(Integer chargeType) {
        this.chargeType = chargeType;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getAdvertId() {
        return advertId;
    }

    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    public String getAdvertName() {
        return advertName;
    }

    public void setAdvertName(String advertName) {
        this.advertName = advertName;
    }

    public String getAdvertTag() {
        return advertTag;
    }

    public void setAdvertTag(String advertTag) {
        this.advertTag = advertTag;
    }

    public String getAeName() {
        return aeName;
    }

    public void setAeName(String aeName) {
        this.aeName = aeName;
    }

    public String getAdvertBudgetPerDay() {
        return advertBudgetPerDay;
    }

    public void setAdvertBudgetPerDay(String advertBudgetPerDay) {
        this.advertBudgetPerDay = advertBudgetPerDay;
    }

    public Integer getAdvertValidStatus() {
        return advertValidStatus;
    }

    public void setAdvertValidStatus(Integer advertValidStatus) {
        this.advertValidStatus = advertValidStatus;
    }

    public Long getOrientPackageId() {
        return orientPackageId;
    }

    public void setOrientPackageId(Long orientPackageId) {
        this.orientPackageId = orientPackageId;
    }

    public Long getOrientBudgetPerDay() {
        return orientBudgetPerDay;
    }

    public void setOrientBudgetPerDay(Long orientBudgetPerDay) {
        this.orientBudgetPerDay = orientBudgetPerDay;
    }

    public Long getFee() {
        return fee;
    }

    public void setFee(Long fee) {
        this.fee = fee;
    }

    public Integer getOrientEnableStatus() {
        return orientEnableStatus;
    }

    public void setOrientEnableStatus(Integer orientEnableStatus) {
        this.orientEnableStatus = orientEnableStatus;
    }

    public Integer getAdvertType() {
        return advertType;
    }

    public void setAdvertType(Integer advertType) {
        this.advertType = advertType;
    }

    public Integer getIsDefault() {
        return isDefault;
    }

    public void setIsDefault(Integer isDefault) {
        this.isDefault = isDefault;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
