package cn.com.duiba.tuia.core.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.LandMappingDto;
import cn.com.duiba.tuia.core.api.dto.advert.AdvertLandMappingDto;

import java.util.List;
import java.util.Map;

/**
 * @Author:zhangmeng
 * @Date:2018-05-25
 * @Function:用于获取广告主平台落地页相关数据
 */
@AdvancedFeignClient
public interface RemoteLandPageService {
    /**
     * 新增一条落地页id，和加密id映射数据
     */
    Integer insertLandMappingItem(LandMappingDto landMappingDto);

    /**
     * 获取映射表中的数据通过落地页id
     */
    List<LandMappingDto>getLandMappingItems(List<Long> ids);

    /**
     * 获取映射表中的数据通过落地页映射id
     */
    LandMappingDto getLandMappingItem(String anonymousId);

    /**
     * 获取真实落地页地址
     */
    String getRealPromoteUrl(String promoteURL);

    /**
     * 获取展示页面商的落地页地址
     */
    String getAnonymousUrl(String promoteURL);

}
