package cn.com.duiba.tuia.core.api.remoteservice.app;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.AdvertLimitDto;
import cn.com.duiba.tuia.core.api.dto.PageDto;
import cn.com.duiba.tuia.core.api.dto.app.AdBaseInfoDto;
import cn.com.duiba.tuia.core.api.dto.req.app.ReqAppPackageAddAdvert;
import cn.com.duiba.tuia.core.api.dto.req.app.ReqAppPackageAddDto;
import cn.com.duiba.tuia.core.api.dto.req.app.ReqAppPackageQueryDto;
import cn.com.duiba.tuia.core.api.dto.req.app.ReqAppPackageUpdateDto;
import cn.com.duiba.tuia.core.api.dto.req.app.ReqUpdateAppFlowOrientPkg;
import cn.com.duiba.tuia.core.api.dto.rsp.advert.RspAdvertSimpleInfoDto;
import cn.com.duiba.tuia.core.api.dto.rsp.app.RspAppPackAddAppResultDto;
import cn.com.duiba.tuia.core.api.dto.rsp.app.RspAppPackDto;
import cn.com.duiba.tuia.core.api.dto.rsp.app.RspAppSimpleInfoDto;
import cn.com.duiba.tuia.core.api.dto.rsp.app.UpdateAppPackageResultDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by 李志辉 on 2017-07-07 14:44.
 */
@AdvancedFeignClient
public interface RemoteAppPackageService {

    /**
     * 增加媒体包
     *
     * @param addDto 新增媒体包类
     * @return 添加结果 true-成功 false 失败
     */
    DubboResult<Boolean> add(ReqAppPackageAddDto addDto);

    /**
     * 更新媒体包
     *
     * @param updateDto 更新媒体包类
     * @return 更新结果 true-成功 false 失败
     */
    DubboResult<Boolean> update(ReqAppPackageUpdateDto updateDto);

    /**
     * 删除流量包下面的媒体 (流量包和媒体包是一个东西)
     *
     * @param id     媒体包id
     * @param appIds 媒体id列表
     * @return 删除结果
     */
    DubboResult<Boolean> deleteApps(Long id, List<Long> appIds);

    /**
     * 媒体包列表(分页查看)
     *
     * @param queryDto 查询条件
     * @return 分页查询的媒体包列表
     */
    DubboResult<PageDto<RspAppPackDto>> list(ReqAppPackageQueryDto queryDto);

    /**
     * 增加媒体
     *
     * @param appIds       媒体id列表
     * @param appPackageId 媒体包id
     * @return 增加媒体列表的结果
     */
    DubboResult<RspAppPackAddAppResultDto> addApps(Long appPackageId, List<Long> appIds);

    /**
     * 查看媒体包详情
     *
     * @param id 媒体包id
     * @return 媒体包详情
     */
    DubboResult<RspAppPackDto> detail(Long id);

    /**
     * 查看这个媒体包下面关联的广告列表,纬度是定向配置
     *
     * @param appPackageId
     * @return
     */
    DubboResult<List<RspAdvertSimpleInfoDto>> getAssociateAdvertList(Long appPackageId);

    /**
     * 查看跟媒体包关联的广告列表-定向配置维度
     *
     * @param appPackageId 媒体包id
     * @param type         1：查询定向媒体对应的广告及配置包列表,2：查询限流媒体对应的广告及配置包列表
     * @return 广告列表-定向配置纬度
     */
    List<AdBaseInfoDto> queryAppPkgAssociateAdvertList(Long appPackageId, Integer type);

    /**
     * 添加限流广告和定向广告
     */
    Boolean addAppPackageAdvert(ReqAppPackageAddAdvert req);

    /**
     * 移除流量包限流媒体关联的广告
     *
     * @param appPackageId 流量包id
     * @param advertId     广告id
     */
    Boolean deleteLimitFlowAppAdvert(Long appPackageId, Long advertId);

    /**
     * 流量包更新广告配置包
     */
    Boolean updateAppFlowOrientPkg(ReqUpdateAppFlowOrientPkg req);

    /**
     * 更新限流媒体包
     *
     * @param advertId               广告id
     * @param orientPkgId            配置包id
     * @param limitFlowAppPackageIds 限流媒体流量包id
     */
    @Deprecated
    Boolean updateLimitFlowAppPackage(Long advertId, Long orientPkgId, List<Long> limitFlowAppPackageIds);

    /**
     * 查询流量包及对应的媒体信息列表
     *
     * @param appPackageIds 流量包IDS
     */
    List<AdvertLimitDto> queryAppPackageLimitFlowApp(List<Long> appPackageIds, Long advertId, Long orientPkgId);

    /**
     * 取消关联
     *
     * @param appPackageId                媒体包id
     * @param advertOrientationPackageIds 定向配置包id列表
     * @return 取消结果
     */
    DubboResult<Boolean> cancelAssociate(Long appPackageId, List<Long> advertOrientationPackageIds);

    /**
     * 过滤重复的媒体,根据媒体包id列表和给定的媒体id列表,删除两者之间重复的媒体(不影响媒体包),并返回去重后的结果
     *
     * @param appPackageIds 媒体包id列表
     * @param appIds        媒体id列表
     * @return 去重后的媒体列表
     */
    DubboResult<List<RspAppSimpleInfoDto>> filterDuplicateAppList(List<Long> appPackageIds, List<Long> appIds);

    List<Long> getCommonAppIdList(List<Long> appPackageIds, List<Long> appIds);

    /**
     * 通过媒体id列表获取媒体的简单信息
     *
     * @param appIds 媒体id列表
     * @return 媒体列表(简单信息)
     */
    DubboResult<List<RspAppSimpleInfoDto>> getSimpleAppInfo(List<Long> appIds);

    /**
     * 通过媒体包id列表获取所有媒体包中的媒体列表(返回结果是去重复的)
     *
     * @param appPackageIds 媒体包id列表
     * @return 去重后的媒体列表(简单信息)
     */
    DubboResult<List<RspAppSimpleInfoDto>> getAppsByIds(List<Long> appPackageIds);

    /**
     * 获取媒体包列表(不包含媒体包下面的媒体列表)
     *
     * @param queryDto 查询条件
     * @return 媒体包列表
     */
    DubboResult<List<RspAppPackDto>> simpleList(ReqAppPackageQueryDto queryDto);

    void addPackageSlots(Long appId,Long packageId,List<Long> slotIds);

    /**
     * 
     * updatePackageLimitFlowAppPackage:(更新限流媒体包,返回更新结果). <br/>
     *
     * @author chencheng
     * @param advertId
     * @param orientPkgId
     * @param limitFlowAppPackageIds
     * @return
     * @since JDK 1.8
     */
    UpdateAppPackageResultDto updatePackageLimitFlowAppPackage(Long advertId, Long orientPkgId, List<Long> limitFlowAppPackageIds);
}
