package cn.com.duiba.tuia.core.api.remoteservice.app;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.TagAdvertInfoDto;
import cn.com.duiba.tuia.core.api.dto.TagAdvertNumDto;
import cn.com.duiba.tuia.core.api.dto.req.MediaTagReq;
import cn.com.duiba.tuia.core.api.dto.req.ShieldConsumeRatioReq;

import java.math.BigDecimal;
import java.util.List;

/**
 * 媒体-广告双向屏蔽
 *
 * @author huangchaohui
 */
@AdvancedFeignClient
public interface RemoteAppShieldAdvertService {

    /**
     * 统计标签对应的广告数量
     *
     * @return 可见标签对应广告去除屏蔽标签下的广告集合
     */
    List<TagAdvertNumDto> countTagAdvert(MediaTagReq req);

    /**
     * 查询标签对应的广告列表详情
     *
     * @return 广告详情
     */
    List<TagAdvertInfoDto> queryTagAdvertList(MediaTagReq req);

    /**
     * 过滤新的广告集合,去掉屏蔽的标签对应的广告
     *
     * @return 过滤之后符合条件的新广告ID集合
     */
    List<Long> filterShieldAdvertList(MediaTagReq req);

    /**
     * 获取未屏蔽的消耗占比
     *
     * @return 4位精度的小数
     */
    BigDecimal getNotShieldConsumeRatio(ShieldConsumeRatioReq req);
}
