package cn.com.duiba.tuia.core.api.remoteservice.data;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.rsp.data.RspAdvertPackageHourTransformDto;
import cn.com.duiba.tuia.core.api.dto.rsp.data.RspAdvertPackageTransformDto;
import cn.com.duiba.tuia.core.api.statistics.domain.GetPackageDailyDataReq;
import cn.com.duiba.tuia.core.api.statistics.domain.QueryPackageDataByHourReq;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * Created by MichealWang on 2018/9/9 0009.
 */
@AdvancedFeignClient
public interface RemotePackageAdvertService {
    /**
     * 查询定向配置每日统计数据 条数
     */
    DubboResult<Integer> getDailyDataAmount(GetPackageDailyDataReq req);

    /**
     * 查询定向配置每日统计数据
     * @param req
     * @return
     */
    DubboResult<List<RspAdvertPackageTransformDto>> getDailyData(GetPackageDailyDataReq req);

    /**
     * 查询定向配置每日统计数据
     * @param req
     * @return
     */
    DubboResult<RspAdvertPackageTransformDto> getDailyDataSum(GetPackageDailyDataReq req);

    /**
     * 查询定向配资每小时统计数据 条数
     * @param req
     * @return
     */
    DubboResult<Integer> selectDataByHourAmount(QueryPackageDataByHourReq req);

    /**
     * 查询定向配置每小时统计数据
     * @param req
     * @return
     */
    public DubboResult<List<RspAdvertPackageHourTransformDto>> selectDataByHour(QueryPackageDataByHourReq req);

    /**
     * 查询定向配置每小时统计数据
     * @param req
     * @return
     */
    DubboResult<RspAdvertPackageHourTransformDto> selectDataByHourSum(QueryPackageDataByHourReq req);


}
