/**
 * 文件名： ByDateQueryReq.java 此类描述的是： 作者: leiliang 创建时间: 2016年4月21日 上午10:54:21
 */
package cn.com.duiba.tuia.core.api.statistics.domain;

import io.swagger.annotations.ApiModelProperty;

import org.springframework.format.annotation.DateTimeFormat;

/**
 * 按日期分页查询
 * 
 * @author: leiliang
 * @version:
 */
public class ByDateQueryReq extends BaseQueryReq {

    private static final long serialVersionUID = -4050540694496810908L;

    /** 开始时间. */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty(value="开始时间,yyyy-MM-dd")
    private String startDate;

    /** 结束时间. */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty(value="结束时间,yyyy-MM-dd")
    private String endDate;
    
    /** 0 or null ：汇总，1：分日 */
    @ApiModelProperty(value="0 or null ：汇总，1：分日")
    private Integer exportType;

    /**
     * Creates a new instance of ByDateQueryReq.
     */

    public ByDateQueryReq() {
        super();
    }

    /**
     * Creates a new instance of ByDateQueryReq.
     *
     * @param startDate
     * @param endDate
     */

    public ByDateQueryReq(String startDate, String endDate) {
        super();
        this.startDate = startDate;
        this.endDate = endDate;
    }

    /**
     * startDate.
     *
     * @return the startDate
     * @since JDK 1.7
     */
    public String getStartDate() {
        return startDate;
    }

    /**
     * startDate.
     *
     * @param startDate the startDate to set
     * @since JDK 1.7
     */
    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    /**
     * endDate.
     *
     * @return the endDate
     * @since JDK 1.7
     */
    public String getEndDate() {
        return endDate;
    }

    /**
     * endDate.
     *
     * @param endDate the endDate to set
     * @since JDK 1.7
     */
    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public Integer getExportType() {
        return exportType;
    }

    public void setExportType(Integer exportType) {
        this.exportType = exportType;
    }

    /**
     * @see Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ByDateQueryReq [startDate=");
        builder.append(startDate);
        builder.append(", endDate=");
        builder.append(endDate);
        builder.append("]");
        return builder.toString();
    }

}
