package cn.com.duiba.tuia.core.api.enums.statistics;

import cn.com.duiba.tuia.core.api.dto.statistics.TitleHeader;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Maps;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * ClassName: AdvertDayStatisticsTitleEnum <br/>
 * Function: 每日广告数据标题. <br/>
 * date: 2018年4月20日 下午2:15:41 <br/>
 *
 * @author chencheng
 * @version 
 * @since JDK 1.8
 */
public enum AdvertDayStatisticsTitleEnum {

    /** 日期 */
    CUR_DATE(0, "curDate", "日期"),
    
    /** 广告状态名称 */
    VALID_STATUS_NAME(0, "validStatusName", "当日广告状态"),

    /** 预算 */
    BUDGET(0, "budget", "预算"),

    /** 消费 */
    CONSUME_TOTAL(0, "consumeTotal", "消费"),

    /** 转化成本 消耗/转化pv */
    EFFECT_COST(0, "effectCost", "转化成本"),

    /** 发券pv */
    LAUNCH_COUNT(0, "launchCount", "发券pv"),
    

    /** 计费点击pv */
    EF_CLICK_COUNT(0, "efClickCount", "计费点击pv"),
    

    /** 计费点击率  CTR*/
    CLICK_RATE(0, "clickRate", "CTR"),
    
    /** 落地页访问PV */
    VISIT_PV(0, "visitPv", "落地页访问pv"),


    /** 落地页到达率 */
    LOSS(0, "loss", "落地页到达率"),
    
    /** 转化PV */
    EFFECT_PV(0, "effectPv", "转化PV"),
    
    /** CVR */
    CVR(0, "cvr", "CVR"),

    
    /** 计费点击均价 */
    AVERAGE_PRICE(3, "averagePrice", "计费点击均价");
    

    /** 类型：0-公用，1-页面展示标题，2-导出标题,3-转化数据后追加的公用标题，4-转化数据后追加的展示标题，5-转化数据后追加的导出标题 */
    private Integer type;
    
    private String code;

    private String desc;
    
    private AdvertDayStatisticsTitleEnum(Integer type, String code, String desc) {
        this.type = type;
        this.code = code;
        this.desc = desc;
    }

    /**
     * type.
     *
     * @return  the type
     * @since   JDK 1.8
     */
    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public String getCode() {
        return code;
    }

    private static Map<String, AdvertDayStatisticsTitleEnum> enumMap = Maps.newHashMap();
    /** 固定数据标题 */
    private static List<TitleHeader> advertDayStatisticsTitleList = new ArrayList<>(AdvertDayStatisticsTitleEnum.values().length*2);
    private static List<TitleHeader> advertDayStatisticsExporyTitleList = new ArrayList<>(AdvertDayStatisticsTitleEnum.values().length*2);
    private static List<TitleHeader> advertDayOtherTitleList = new ArrayList<>(AdvertDayStatisticsTitleEnum.values().length);
    private static List<TitleHeader> advertDayOtherExportTitleList = new ArrayList<>(AdvertDayStatisticsTitleEnum.values().length);
    static {
        for (AdvertDayStatisticsTitleEnum it : AdvertDayStatisticsTitleEnum.values()) {
            enumMap.put(it.getCode(), it);
            switch (it.type) {
                case 0:
                    advertDayStatisticsTitleList.add(new TitleHeader(it.getCode(), it.getDesc()));
                    advertDayStatisticsExporyTitleList.add(new TitleHeader(it.getCode(), it.getDesc()));
                    break;
                case 1:
                    advertDayStatisticsTitleList.add(new TitleHeader(it.getCode(), it.getDesc()));
                    break;
                case 2:
                    advertDayStatisticsExporyTitleList.add(new TitleHeader(it.getCode(), it.getDesc()));
                    break;
                case 3:
                    advertDayOtherTitleList.add(new TitleHeader(it.getCode(), it.getDesc()));
                    break;
                case 5:
                    advertDayOtherExportTitleList.add(new TitleHeader(it.getCode(), it.getDesc()));
                    break;
                default:
                    break;
            }
        }
    }

    /**
     * 
     * getAdvertDayStatisticsTitle:(获取转化标题前固定标题，1-展示，2-导出). <br/>
     *
     * @author chencheng
     * @return
     * @since JDK 1.8
     */
    public static List<TitleHeader> getAdvertDayStatisticsTitle(Integer type) {
        if (type.intValue() == 1) {
            return BeanUtils.copyList(advertDayStatisticsTitleList, TitleHeader.class);
        }else{
            return BeanUtils.copyList(advertDayStatisticsExporyTitleList, TitleHeader.class);
        }
    }
    

    public static AdvertDayStatisticsTitleEnum getByCode(String code) {
        return enumMap.get(code);
    }

    /**
     * 
     * addOtherTitle:(其他标题追加，转化数据标题放在这些标题之前). <br/>
     *
     * @author chencheng
     * @param advertDayStatisticsTitle
     * @since JDK 1.8
     */
    public static void addOtherTitle(List<TitleHeader> advertDayStatisticsTitle) {
        advertDayStatisticsTitle.addAll(advertDayOtherTitleList);
    }
    
    /**
     * 
     * addOtherTitle:(转化数据后追加的导出标题). <br/>
     *
     * @author chencheng
     * @param advertDayStatisticsTitle
     * @since JDK 1.8
     */
    public static void addOtherExportTitleList(List<TitleHeader> advertDayStatisticsTitle) {
        advertDayStatisticsTitle.addAll(advertDayOtherExportTitleList);
    }
    
}
