/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.core.api.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;

public class FinanceUtils {
    public static final Long DENOMINATOR = 10000000000L;

    private FinanceUtils() {
    }

    public static BigDecimal getRate(Long rate) {
        return BigDecimal.valueOf(rate).divide(BigDecimal.valueOf(DENOMINATOR), 10, RoundingMode.HALF_UP);
    }

    public static Long cashBackTransfer(Long amount) {
        return BigDecimal.valueOf(amount).divide(BigDecimal.valueOf(DENOMINATOR), 0, RoundingMode.HALF_UP).longValue();
    }

    public static Long getRate(BigDecimal rate) {
        return rate.multiply(BigDecimal.valueOf(DENOMINATOR)).setScale(0, RoundingMode.HALF_UP).longValue();
    }

    public static BigDecimal getRate(Long cashBack, Long totalBalance) {
        if (cashBack.equals(0L) || totalBalance.equals(0L)) {
            return BigDecimal.valueOf(0L);
        }
        return BigDecimal.valueOf(cashBack).divide(BigDecimal.valueOf(totalBalance), 10, RoundingMode.HALF_UP);
    }

    public static Long calculate(Long number, Long rate) {
        return BigDecimal.valueOf(number).multiply(FinanceUtils.getRate(rate)).setScale(0, RoundingMode.HALF_UP).longValue();
    }

    public static BigDecimal floatChangeCalculate(Long dividend, Long divisor) {
        if (dividend == 0L || divisor == 0L) {
            return BigDecimal.ZERO;
        }
        return BigDecimal.valueOf(dividend - divisor).divide(BigDecimal.valueOf(divisor), 4, RoundingMode.HALF_UP);
    }

    public static BigDecimal divide(Long dividend, Long divisor) {
        if (dividend == 0L || divisor == 0L) {
            return BigDecimal.ZERO;
        }
        return BigDecimal.valueOf(dividend).divide(BigDecimal.valueOf(divisor), 4, RoundingMode.HALF_UP);
    }

    public static BigDecimal floatChangeCalculate(BigDecimal dividend, BigDecimal divisor) {
        if (dividend == null || divisor == null || dividend.equals(BigDecimal.ZERO) || divisor.equals(BigDecimal.ZERO)) {
            return BigDecimal.ZERO;
        }
        return dividend.subtract(divisor).divide(divisor, 4, RoundingMode.HALF_UP);
    }
}

