/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.core.api.utils;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import net.coobird.thumbnailator.Thumbnails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageUtils {
    private static final Logger logger = LoggerFactory.getLogger(ImageUtils.class);

    public static InputStream compassImage(InputStream inputStream, InputStream backupStream, String fileType, float FoutRate) throws IOException {
        int originSize = inputStream.available();
        if (originSize <= 51200 || "gif".equals(fileType)) {
            return inputStream;
        }
        BufferedImage bufImg = ImageIO.read(inputStream);
        bufImg = Thumbnails.of((BufferedImage[])new BufferedImage[]{bufImg}).height(bufImg.getHeight()).width(bufImg.getWidth()).keepAspectRatio(true).outputQuality(FoutRate).asBufferedImage();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufImg, fileType, bos);
        inputStream = new ByteArrayInputStream(bos.toByteArray());
        int size = inputStream.available();
        logger.info("ImageUtils.compassImage...originSize:{},size:{}", (Object)originSize, (Object)size);
        if (size >= originSize) {
            return backupStream;
        }
        return inputStream;
    }
}

