package cn.com.duiba.tuia.core.api.remoteservice.app;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.AppArpuDto;
import cn.com.duiba.tuia.core.api.dto.app.ReqPageQueryAppDataDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;
import java.util.Map;

@AdvancedFeignClient
public interface RemoteAppArpuService {

    /**
     * 查询所有的应用arpu值
     * @param dto
     * @return
     */
    DubboResult<Map<Long, Double>> selectAllArpu(ReqPageQueryAppDataDto dto);

    /**
     * 批量获取应用arpu值
     * @param dto
     * @return
     */
    DubboResult<Map<Long, Double>> selectAppArpu(ReqPageQueryAppDataDto dto);

    /**
     * 统计有应用arpu个数
     * @return
     */
    DubboResult<Long> countAppArpu();

    /**
     * 批量增加app的arpu
     * @param appArpuDOS
     * @return
     */
    DubboResult<Integer> insertAppArpu(List<AppArpuDto> appArpuDOS);

    /**
     * 批量修改应用arpu值
     * @param appIds
     * @param arpu
     */
    void updateAppArpu(List<Long> appIds, Double arpu);

    /**
     * 移除应用arpu值
     * @param appIds
     * @return
     */
    DubboResult<Integer> deleteAppArpu(List<Long> appIds);
}
