/**
 * 文件名： AdvertStatisticsDayModel.java 此类描述的是： 作者: zufengze 创建时间: 2016年3月24日 下午3:35:16
 */
package cn.com.duiba.tuia.core.api.statistics.domain;

import org.apache.commons.lang.builder.ToStringBuilder;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 广告统计数据.
 *
 * @author: zufengze
 * @创建时间: 2016年4月21日 下午3:35:16
 * @version:
 */
public class AdvertStatisticsRsp extends AdvertStatisticsData {

    private static final long         serialVersionUID = -1837740607725655427L;

    /** 广告ID. */
    private Long                      id;

    //广告类型
    private Integer advertType;

    /** 广告名称. */
    private String                    advertName;

    /** The billing count. */
    private Long                      billingCount;

    /** 广告主ID. */
    private Long                      advertiserId;

    /** 广告主名称. */
    private String                    companyName;

    /** 代理商名称. */
    private String                    agentCompanyName;

    /** 广告关联的兑换券信息. */
    private List<AdvertStatisticsRsp> children;

    /** 当前日期. */
    private Date                      curDate;

    /** 实际消费 */
    private BigDecimal                correctionTotal;

    /** AE名称 */
    private String                    aeName;

    /** 销售名称 */
    private String                    sellName;

    /** 新行业名称 */
    private String                    newTradeName;

    /** 广告状态 @{AdvertValidStatusEnum} */
    private Integer                   validStatus;

    /** 广告状态名称，用于页面展示 */
    private String                    validStatusName;

    /** 预算 */
    private Long                      budget;

    //ctr诊断结果，如：好、差、一般、很差、不确定等
    private String                    diagnosticResultCtr;

    //ctr诊断的详细内容
    private String                    comDiagnosticContentCtr;

    //cvr诊断结果，如：好、差、一般、很差、不确定等
    private String                    diagnosticResultCvr;

    //cvr诊断的详细内容
    private String                    comDiagnosticContentCvr;

    /** 广告分析标签名称 */
    private String                    analysisTagName;
    
    /** 广告特征标签名称 */
    private String                    matchTagName;

    /** 广告落地页标签名称 */
    private String                     landPageTagName;

    /** 一级代理商公司名称. */
    private String                    oneLevelAgentName;

    /** 二级代理商公司名称. */
    private String                    twoLevelAgentName;

    /** 三级代理商公司名称. */
    private String                    threeLevelAgentName;

    /** 四级代理商公司名称. */
    private String                    fourLevelAgentName;

    /**广告失效状态zm*/
    private Boolean abate;

    /** 广告关联的资源标签名称 */
    private String advertResourceTagName;

    /** 前三天的成本均值 **/
    private Long costChange;

    /** 成本变化 9.00% **/
    private String costChangeStr;

    public String getCostChangeStr() {
        return costChangeStr;
    }

    public void setCostChangeStr(String costChangeStr) {
        this.costChangeStr = costChangeStr;
    }

    public Long getCostChange() {
        return costChange;
    }

    public void setCostChange(Long costChange) {
        this.costChange = costChange;
    }

    public String getAdvertResourceTagName() {
        return advertResourceTagName;
    }

    public void setAdvertResourceTagName(String advertResourceTagName) {
        this.advertResourceTagName = advertResourceTagName;
    }

    public Boolean getAbate() {
        return abate;
    }

    public void setAbate(Boolean abate) {
        this.abate = abate;
    }

    /**
     * oneLevelAgentName.
     *
     * @return the oneLevelAgentName
     * @since JDK 1.8
     */
    public String getOneLevelAgentName() {
        return oneLevelAgentName;
    }

    /**
     * oneLevelAgentName.
     *
     * @param oneLevelAgentName the oneLevelAgentName to set
     * @since JDK 1.8
     */
    public void setOneLevelAgentName(String oneLevelAgentName) {
        this.oneLevelAgentName = oneLevelAgentName;
    }

    public Integer getAdvertType() {
        return advertType;
    }

    public void setAdvertType(Integer advertType) {
        this.advertType = advertType;
    }

    /**
     * twoLevelAgentName.
     *
     * @return the twoLevelAgentName
     * @since JDK 1.8
     */
    public String getTwoLevelAgentName() {
        return twoLevelAgentName;
    }

    /**
     * twoLevelAgentName.
     *
     * @param twoLevelAgentName the twoLevelAgentName to set
     * @since JDK 1.8
     */
    public void setTwoLevelAgentName(String twoLevelAgentName) {
        this.twoLevelAgentName = twoLevelAgentName;
    }

    /**
     * threeLevelAgentName.
     *
     * @return the threeLevelAgentName
     * @since JDK 1.8
     */
    public String getThreeLevelAgentName() {
        return threeLevelAgentName;
    }

    /**
     * threeLevelAgentName.
     *
     * @param threeLevelAgentName the threeLevelAgentName to set
     * @since JDK 1.8
     */
    public void setThreeLevelAgentName(String threeLevelAgentName) {
        this.threeLevelAgentName = threeLevelAgentName;
    }

    /**
     * fourLevelAgentName.
     *
     * @return the fourLevelAgentName
     * @since JDK 1.8
     */
    public String getFourLevelAgentName() {
        return fourLevelAgentName;
    }

    /**
     * fourLevelAgentName.
     *
     * @param fourLevelAgentName the fourLevelAgentName to set
     * @since JDK 1.8
     */
    public void setFourLevelAgentName(String fourLevelAgentName) {
        this.fourLevelAgentName = fourLevelAgentName;
    }

    public String getLandPageTagName() {
        return landPageTagName;
    }

    public void setLandPageTagName(String landPageTagName) {
        this.landPageTagName = landPageTagName;
    }

    /**
     * matchTagName.
     *
     * @return  the matchTagName
     * @since   JDK 1.8
     */
    public String getMatchTagName() {
        return matchTagName;
    }
    
    /**
     * matchTagName.
     *
     * @param   matchTagName    the matchTagName to set
     * @since   JDK 1.8
     */
    public void setMatchTagName(String matchTagName) {
        this.matchTagName = matchTagName;
    }

    /**
     * newTradeName.
     *
     * @return  the newTradeName
     * @since   JDK 1.8
     */
    public String getNewTradeName() {
        return newTradeName;
    }
    
    /**
     * newTradeName.
     *
     * @param   newTradeName    the newTradeName to set
     * @since   JDK 1.8
     */
    public void setNewTradeName(String newTradeName) {
        this.newTradeName = newTradeName;
    }

    /**
     * analysisTagName.
     *
     * @return  the analysisTagName
     * @since   JDK 1.8
     */
    public String getAnalysisTagName() {
        return analysisTagName;
    }
    
    /**
     * analysisTagName.
     *
     * @param   analysisTagName    the analysisTagName to set
     * @since   JDK 1.8
     */
    public void setAnalysisTagName(String analysisTagName) {
        this.analysisTagName = analysisTagName;
    }

    public String getDiagnosticResultCtr() {
        return diagnosticResultCtr;
    }

    public void setDiagnosticResultCtr(String diagnosticResultCtr) {
        this.diagnosticResultCtr = diagnosticResultCtr;
    }

    public String getComDiagnosticContentCtr() {
        return comDiagnosticContentCtr;
    }

    public void setComDiagnosticContentCtr(String comDiagnosticContentCtr) {
        this.comDiagnosticContentCtr = comDiagnosticContentCtr;
    }

    public String getDiagnosticResultCvr() {
        return diagnosticResultCvr;
    }

    public void setDiagnosticResultCvr(String diagnosticResultCvr) {
        this.diagnosticResultCvr = diagnosticResultCvr;
    }

    public String getComDiagnosticContentCvr() {
        return comDiagnosticContentCvr;
    }

    public void setComDiagnosticContentCvr(String comDiagnosticContentCvr) {
        this.comDiagnosticContentCvr = comDiagnosticContentCvr;
    }

    /**
     * validStatusName.
     *
     * @return the validStatusName
     * @since JDK 1.8
     */
    public String getValidStatusName() {
        return validStatusName;
    }

    /**
     * validStatusName.
     *
     * @param validStatusName the validStatusName to set
     * @since JDK 1.8
     */
    public void setValidStatusName(String validStatusName) {
        this.validStatusName = validStatusName;
    }

    /**
     * budget.
     *
     * @return the budget
     * @since JDK 1.8
     */
    public Long getBudget() {
        return budget;
    }

    /**
     * budget.
     *
     * @param budget the budget to set
     * @since JDK 1.8
     */
    public void setBudget(Long budget) {
        this.budget = budget;
    }

    /**
     * validStatus.
     *
     * @return the validStatus
     * @since JDK 1.8
     */
    public Integer getValidStatus() {
        return validStatus;
    }

    /**
     * validStatus.
     *
     * @param validStatus the validStatus to set
     * @since JDK 1.8
     */
    public void setValidStatus(Integer validStatus) {
        this.validStatus = validStatus;
    }

    /**
     * Gets the id.
     *
     * @return the id
     */
    public Long getId() {
        return id;
    }

    /**
     * Sets the id.
     *
     * @param id the id to set
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * Gets the advertiser id.
     *
     * @return the advertiser id
     */
    public Long getAdvertiserId() {
        return advertiserId;
    }

    /**
     * Sets the advertiser id.
     *
     * @param advertiserId the advertiser id
     */
    public void setAdvertiserId(Long advertiserId) {
        this.advertiserId = advertiserId;
    }

    /**
     * Gets the advert name.
     *
     * @return the advertName
     */
    public String getAdvertName() {
        return advertName;
    }

    /**
     * Sets the advert name.
     *
     * @param advertName the advertName to set
     */
    public void setAdvertName(String advertName) {
        this.advertName = advertName;
    }

    /**
     * Gets the billing count.
     *
     * @return the billingCount
     */
    public Long getBillingCount() {
        return billingCount;
    }

    /**
     * Sets the billing count.
     *
     * @param billingCount the billingCount to set
     */
    public void setBillingCount(Long billingCount) {
        this.billingCount = billingCount;
    }

    /**
     * Gets the children.
     *
     * @return the children
     */
    public List<AdvertStatisticsRsp> getChildren() {
        return children;
    }

    /**
     * Sets the children.
     *
     * @param children the children
     */
    public void setChildren(List<AdvertStatisticsRsp> children) {
        this.children = children;
    }

    /**
     * Gets the companyName.
     *
     * @return the companyName
     */
    public String getCompanyName() {
        return companyName;
    }

    /**
     * Sets the companyName.
     *
     * @param companyName the companyName to set
     */
    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    /**
     * Gets the agentCompanyName.
     *
     * @return the agentCompanyName
     */
    public String getAgentCompanyName() {
        return agentCompanyName;
    }

    /**
     * Sets the agentCompanyName.
     *
     * @param agentCompanyName the agentCompanyName to set
     */
    public void setAgentCompanyName(String agentCompanyName) {
        this.agentCompanyName = agentCompanyName;
    }

    public Date getCurDate() {
        return curDate;
    }

    public void setCurDate(Date curDate) {
        this.curDate = curDate;
    }

    public BigDecimal getCorrectionTotal() {
        return correctionTotal;
    }

    public void setCorrectionTotal(BigDecimal correctionTotal) {
        this.correctionTotal = correctionTotal;
    }

    public String getAeName() {
        return aeName;
    }

    public void setAeName(String aeName) {
        this.aeName = aeName;
    }

    public String getSellName() {
        return sellName;
    }

    public void setSellName(String sellName) {
        this.sellName = sellName;
    }

    /**
     * To string.
     *
     * @return the string
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);

    }

}
