package cn.com.duiba.tuia.core.api.dto.advertiser;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import java.io.Serializable;

/**
 * 广告主简单信息对象
 *
 * @author chensong
 * @create 2019-01-15
 */
public class AdvertiserSimpleDto implements Serializable{

    private static final long serialVersionUID = 2868449252473390148L;

    /** 未冻结. */
    public static final int UNFREEZED_STATUS = 0;

    /** 已冻结. */
    public static final int FREEZED_STATUS = 1;

    /** 广告主id */
    private Long id;

    /** 公司名称 */
    private String companyName;

    /** 代理商名称 */
    private String agentCompanyName;

    /** 一级代理商名称 */
    private String oneLevelAgentName;

    /** AE名称 */
    private String aeName;

    /** 销售名称 */
    private String sellName;

    /** 冻结状态:0：未冻结;1：冻结. */
    private Integer freezeStatus;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getAgentCompanyName() {
        return agentCompanyName;
    }

    public void setAgentCompanyName(String agentCompanyName) {
        this.agentCompanyName = agentCompanyName;
    }

    public String getOneLevelAgentName() {
        return oneLevelAgentName;
    }

    public void setOneLevelAgentName(String oneLevelAgentName) {
        this.oneLevelAgentName = oneLevelAgentName;
    }

    public String getAeName() {
        return aeName;
    }

    public void setAeName(String aeName) {
        this.aeName = aeName;
    }

    public String getSellName() {
        return sellName;
    }

    public void setSellName(String sellName) {
        this.sellName = sellName;
    }

    public Integer getFreezeStatus() {
        return freezeStatus;
    }

    public void setFreezeStatus(Integer freezeStatus) {
        this.freezeStatus = freezeStatus;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }

    @Override
    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals(this, obj);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this, false);
    }

}
