package cn.com.duiba.tuia.core.api.dto.compensate;

import cn.com.duiba.tuia.core.api.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;

/**
 * 广告新赔付DTO
 *
 * @author zhangbaiqiang
 * @date 2021/1/5
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class CompensateNewAdvertDTO extends BaseDto implements Serializable {
    private static final long serialVersionUID = -9123216165075985808L;

    /**
     * 赔付日期
     */
    private Date compensateDate;

    /**
     * 计划id
     */
    private Long advertId;

    /**
     * 转化数
     */
    private Integer transferPv;

    /**
     * 赔付金额
     */
    private Integer compensateAmount;

    /**
     * 是否新计划（0.老计划；1.新计划）
     */
    private Integer isNew;
}
