package cn.com.duiba.tuia.core.api.enums;

/**
 * 拒绝理由分类枚举
 *
 * @author zhangbaiqiang
 * @date 2020/10/19
 */
public enum AdvertRefuseCategoryEnum {

    QUALIFICATION(1, "资质类"),
    INFORMATION(2,"文案类"),
    PICTURE(3, "图片类"),
    LANDPAGE(4, "落地页链接类"),
    RESOURCE(5, "资源类");


    private Integer type;
    private String desc;

    AdvertRefuseCategoryEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static String getDescByType(Integer type) {
        for (AdvertRefuseCategoryEnum item : AdvertRefuseCategoryEnum.values()) {
            if (item.type.equals(type)) {
                return item.desc;
            }
        }
        return null;
    }
}
