package cn.com.duiba.tuia.core.api.remoteservice.advert;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.advert.AdvertSupportPlanDto;
import cn.com.duiba.tuia.core.api.param.AdvertSupportPlanParam;

import java.util.List;

/**
 * Created by ZhangShun on 2018/1/4 12:04
 */
@AdvancedFeignClient
public interface RemoteAdvertSupportPlanService {

    /**
     * 新增和更新广告扶持
     *
     * @param dto
     * @return
     */
    Boolean saveOrUpdate(AdvertSupportPlanDto dto);

    /**
     * 更新扶持状态
     *
     * @param id 计划ID
     * @param state 状态
     * @return
     */
    Boolean updateStateById(Long id, Integer state, String operation);

    /**
     * 根据ID查询
     *
     * @param id
     * @return
     */
    AdvertSupportPlanDto getById(Long id);

    /**
     * 根据广告ID查询
     *
     * @param advertId
     * @return
     */
    AdvertSupportPlanDto getByAdvertId(Long advertId);

    /**
     * 条件查询
     *
     * @param param
     * @return
     */
    Integer countByQuery(AdvertSupportPlanParam param);

    /**
     * 条件查询
     *
     * @param param
     * @return
     */
    List<AdvertSupportPlanDto> findByQuery(AdvertSupportPlanParam param);

    /**
     * 关闭过期任务
     * @return
     */
    void closeSupportPlan();

    /**
     * 查询扶持计划列表
     * @return
     */
    List<AdvertSupportPlanDto> findValidSupportPlan();

    /**
     * 设置是否AB分流
     * @param dto
     * @return
     */
    Integer updateAbShuntById(AdvertSupportPlanDto dto);

}
