package cn.com.duiba.tuia.adx.center.api.dto;

import lombok.Data;
import java.io.Serializable;
import java.util.Date;

@Data
public class ResourceLocationDto implements Serializable {

    private static final long serialVersionUID = -3374718128654703195L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 推广组id
     */
    private Long groupId;

    /**
     * 资源位名称
     */
    private String resourceName;

    /**
     * 资源位投放状态：1.关闭 1.开启
     */
    private Integer switchState;

    /**
     * 预算类型：0.不限 1.自定义
     */
    private Integer budgetType;

    /**
     * 每日预算
     */
    private Double dayBudget;

    /**
     * 付费模式
     */
    private String payType;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 广告位类型主键id
     */
    private Long adTypeId;

    /**
     * 广告位类型模版id
     */
    private String templateId;

    /**
     * 推广组
     */
    private PopularGroupDto popularGroupDto;

}
