package cn.com.duiba.tuia.adx.center.api.dto.tuia.adx.request;

import lombok.Data;

import java.io.Serializable;

/**
 * Created by hong
 * time 2023/11/6.
 */
@Data
public class TuiaAdxDevice implements Serializable {
    private static final long serialVersionUID = 1L;
    /**
     * ip
     */
    private String ip;

    /**
     * 设备类型
     */
    private Integer deviceType;

    /**
     * 设备厂商
     */
    private String make;

    /**
     * 设备型号
     */
    private String model;

    /**
     * 联网类型
     * 0:未知
     * 1:以太网
     * 2:WIFI
     * 3:蜂窝网络
     * 4:2G
     * 5:3G
     * 6:4G
     * 7:5G
     */
    private Integer connectionType;

    /**
     * 运营商
     * 0:未知
     * 1:移动
     * 2:联通
     * 3:电信
     */
    private Integer carrier;

    /**
     * 操作系统
     * 0:安卓
     * 1:IOS
     * 3:其他
     */
    private Integer os;

    /**
     * 操作系统版本
     */
    private String osVersion;

    /**
     * 浏览器ua
     */
    private String ua;

    /**
     * IOS设备唯一标识(加密)
     */
    private String idFaMd5;

    /**
     * oaIdMd5
     */
    private String oaIdMd5;

    /**
     * imeiMd5
     */
    private String imeiMd5;

    /**
     * 设备屏幕宽
     */
    private Integer screenWidth;

    /**
     * 设备屏幕高
     */
    private Integer screenHeight;
}
