package cn.com.duiba.tuia.adx.proxy.service.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.adx.proxy.service.api.constant.AdxTypeEnum;
import cn.com.duiba.tuia.adx.proxy.service.api.dto.advertiser.*;

import java.util.List;

/**
 * 第三方ADX平台广告主送审服务
 */
@AdvancedFeignClient
public interface RemoteAdvertiserService {
    /**
     * 送审广告主
     * @param advertiserDTOList 广告主list
     * @param adxType 某个ADX平台
     * @return 送审结果
     * @throws BizException
     */
    List<AdvertiserAuditResultDTO> audit(List<AdvertiserDTO> advertiserDTOList, AdxTypeEnum adxType) throws BizException;

    /**
     * 修改广告主
     * @param advertiserEditReqList 广告主list
     * @param adxType 某个ADX平台
     * @return 修改结果
     * @throws BizException
     */
    List<AdvertiserEditResultDTO> edit(List<AdvertiserDTO> advertiserEditReqList, AdxTypeEnum adxType)throws BizException;

    /**
     * 查询广告主审核状态
     * @param advertiserStatusQueryDTOList
     * @param adxType
     * @return 审核状态
     * @throws BizException
     */
    List<AdvertiserStatusDTO> queryAuditStatus(List<AdvertiserStatusQueryDTO> advertiserStatusQueryDTOList, AdxTypeEnum adxType)throws BizException;
}
