package cn.com.duiba.tuia.adx.proxy.service.api.constant;

import java.util.Objects;
import java.util.stream.Stream;

public enum AdxTypeEnum {

    /** 2345 ADX */
    NAVIGATION(8, "2345"),

    /**
     * 爱奇艺-联盟
     */
    IQIYI(12, "iqiyi"),

    MEI_SHU(16, "meishu"),

    SOHU(27, "sohu"),

//    SIGMOB(29,"sigmob"), sigmob免审了

    /**
     * 爱奇艺-主站
     */
    IQIYI_MAIN(30, "iqiyi_main"),

    /**
     * 芒果PDB
     */
    MG_PDB(31, "mongo_pdb"),

    /**
     * 芒果TV
     */
    MONGO_TV(14, "mongo_tv"),

    /**
     * 百度视频
     */
    BAIDU_VIDEO(5, "baidushipin"),

    /**
     * 快手联盟
     */
    KUAI_SHOU(36, "kuaishou"),

    /**
     * 优酷
     */
    YOUKU(40, "youku"),

    OPPO(11, "OPPO"),

    ;

    int code;

    String name;

    public int getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    public void setCode(int code) {
        this.code = code;
    }

    AdxTypeEnum(int code, String name){
        this.code = code;
        this.name = name;
    }

    public static AdxTypeEnum getByCode(int code){
        return Objects.isNull(code)
                ? null
                : Stream.of(AdxTypeEnum.values())
                .filter(item -> Objects.equals(item.getCode(), code))
                .findFirst().orElse(null);
    }
}
