package cn.com.duiba.tuia.ai.center.api.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 解析文本
 *
 * @author zhangzhenghe
 * @since 2020-08-11 8:16 PM
 */
@Data
public class TextAnalysisDTO implements Serializable {

    private static final long serialVersionUID = -3481037600640105987L;

    // 降序
    public static final String SORT_DESC = "desc";

    // 升序
    public static final String SORT_ASC = "asc";

    // 词频排序结果最大个数
    public static final int MAX_LIMIT = 5000;

    // 词频排序结果默认个数
    public static final int DEFAULT_LIMIT = 200;

    /**
     * 需分析文本
     */
    private String content;

    /**
     * 分词调用方式
     * 默认TO_ANALYSIS标准分词
     * @link https://nlpchina.github.io/ansj_seg 分词调用方式
     */
    private Integer analysisType;

    /**
     * 停用词性
     * @link https://nlpchina.github.io/ansj_seg 词性说明
     */
    private List<String> stopNatures;

    /**
     * 停用词语
     */
    private List<String> stopWords;

    /**
     * 停用正则表达式
     */
    private List<String> stopRegexes;

    /**
     * 词频分析结果 过滤单个词语
     * 默认过滤：true
     */
    private Boolean noSingleWord;

    /**
     * 词频结果排序方式
     * desc：降序 asc：升序
     * 默认降序
     */
    private String sort;

    /**
     * 词频结果限制数量
     * 默认200，最大数量为5000
     */
    private Integer limit;
}
