package cn.com.duiba.tuia.ai.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ai.center.api.dto.TextAnalysisDTO;
import cn.com.duiba.tuia.ai.center.api.dto.TextAnalysisFrequencyDTO;

import java.util.List;

/**
 * 文本分析
 *
 * @author zhangzhenghe
 * @since 2020-08-11 8:12 PM
 */
@AdvancedFeignClient
public interface RemoteTextAnalysisService {

    /**
     * 分词结果以逗号分割，不含词性
     *
     * @param text 需分析文本
     * @return 分词结果
     */
    String getWordWithOutNature(TextAnalysisDTO text);

    /**
     * 分词结果以逗号分割，包含词性
     *
     * @param text 需分析文本
     * @return 分词结果
     */
    String getWordWithNature(TextAnalysisDTO text);

    /**
     * 分词词频
     *
     * @param text 需分析文本
     * @return 分词词频
     */
    List<TextAnalysisFrequencyDTO> listWordFrequency(TextAnalysisDTO text);
}
