package cn.com.duiba.tuia.ecb.center.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ecb.center.cpd.req.CpdDatasReq;
import cn.com.duiba.tuia.ecb.center.dto.MoneyTreeAdReq;
import cn.com.duiba.tuia.ecb.center.dto.MoneyTreeDetailDto;
import cn.com.duiba.tuia.ecb.center.dto.MoneyTreePrizeDto;

/**
 * 摇钱树
 * Created by xuefeng on 2019/4/23.
 */
@AdvancedFeignClient
public interface RemoteMoneyTreeService {

    /**
     * 查询摇钱树详情
     * @param req
     * @return
     */
    MoneyTreeDetailDto detail(MoneyTreeAdReq req);

    /**
     * 种树
     * @param req
     * @return
     */
    Boolean plant(MoneyTreeAdReq req);

    /**
     * 领取奖励
     * @param userId
     * @param index
     * @return
     */
    MoneyTreePrizeDto pick(Long userId, Integer index, CpdDatasReq datas);

    /**
     * 浇水
     * @param req
     * @return
     */
    Boolean water(MoneyTreeAdReq req);

    /**
     * 用户水量增加
     * @param userId
     * @param waterNum
     * @return
     */
    Boolean addWater(Long userId, Long waterNum);

    /**
     * 用户加水
     * @param userId
     * @param waterNum
     * @return
     */
    Boolean addOwnWater(Long userId, Long waterNum);

    /**
     * 放弃宝箱
     * @param userId
     * @param index
     * @return
     */
    Boolean giveUp(Long userId, Integer index);

    /**
     * 宝箱广告点击
     * @param userId
     * @param index
     * @param id
     * @param appSource
     * @return
     */
    Boolean adClick(Long userId, Integer index, String id, Integer appSource);

    /**
     * 系统成熟
     * @param userId
     * @return
     */
    Boolean systemRipe(Long userId, CpdDatasReq cpdDatasReq);
}
