package cn.com.duiba.tuia.ecb.center.mix.req;

import java.io.Serializable;

/**
 * 闲玩回调请求
 * Created by xuefeng on 2020/3/4.
 */
public class MixXwCallbackReq implements Serializable {


    private static final long serialVersionUID = -7208179404507502259L;

    /**
     * 广告ID (adid=1 特殊活动 price=money)
     */
    private int adid;

    /**
     * 广告名称
     */
    private String adname;

    /**
     * 开发者ID
     */
    private String appid;

    /**
     * 订单编号
     */
    private String ordernum;

    /**
     * 奖励级别
     */
    private int dlevel;

    /**
     * 用户体验游戏的包名
     */
    private String pagename;

    /**
     * 任务奖励类型（2：等级奖励 9：充值奖励 -1：活动奖励 其他：待定）
     */
    private int atype;

    /**
     * 手机设备号 imei 或 idfa
     */
    private String deviceid;

    /**
     * 手机sim卡id
     */
    private String simid;

    /**
     * 开发者用户编号（用户id）
     */
    private String appsign;

    /**
     * 用户体验游戏注册的账号id
     */
    private String merid;

    /**
     * 奖励说明—在开发者自己的APP中需显示给用户看，以便用户了解自己获得的奖励
     */
    private String event;

    /**
     * 广告icon图片地址 ；需URL解码
     */
    private String adicon;

    /**
     * 于开发者结算单价、单位：元 （最多保留2位小数）
     */
    private String price;

    /**
     * 开发者需奖励给用户金额 单位：元 （最多保留2位小数）
     */
    private String money;

    /**
     * 用户获得奖励时间 时间字符串 如：2018/01/24 12:13:24
     */
    private String itime;

    /**
     * 订单校验参数 加密规则
     * MD5(adid+appid+ordernum+dlevel+deviceid
     * +appsign+price+money+key)
     * + 为连接符不做加密 [MD5加密结果需转大写]
     * price与money存在整数的情况，请直接使用传过来的值进行加密或转string后再进行加密校验；避免传值为1但开发者加密的时候却变成1.0的情况出现
     */
    private String keycode;

    public int getAdid() {
        return adid;
    }

    public void setAdid(int adid) {
        this.adid = adid;
    }

    public String getAdname() {
        return adname;
    }

    public void setAdname(String adname) {
        this.adname = adname;
    }

    public int getDlevel() {
        return dlevel;
    }

    public void setDlevel(int dlevel) {
        this.dlevel = dlevel;
    }

    public String getPagename() {
        return pagename;
    }

    public void setPagename(String pagename) {
        this.pagename = pagename;
    }

    public int getAtype() {
        return atype;
    }

    public void setAtype(int atype) {
        this.atype = atype;
    }

    public String getDeviceid() {
        return deviceid;
    }

    public void setDeviceid(String deviceid) {
        this.deviceid = deviceid;
    }

    public String getSimid() {
        return simid;
    }

    public void setSimid(String simid) {
        this.simid = simid;
    }

    public String getAppsign() {
        return appsign;
    }

    public void setAppsign(String appsign) {
        this.appsign = appsign;
    }

    public String getMerid() {
        return merid;
    }

    public void setMerid(String merid) {
        this.merid = merid;
    }

    public String getEvent() {
        return event;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public String getAdicon() {
        return adicon;
    }

    public void setAdicon(String adicon) {
        this.adicon = adicon;
    }

    public String getPrice() {
        return price;
    }

    public void setPrice(String price) {
        this.price = price;
    }

    public String getMoney() {
        return money;
    }

    public void setMoney(String money) {
        this.money = money;
    }

    public String getItime() {
        return itime;
    }

    public void setItime(String itime) {
        this.itime = itime;
    }

    public String getKeycode() {
        return keycode;
    }

    public void setKeycode(String keycode) {
        this.keycode = keycode;
    }

    public String getAppid() {
        return appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public String getOrdernum() {
        return ordernum;
    }

    public void setOrdernum(String ordernum) {
        this.ordernum = ordernum;
    }
}
