package cn.com.duiba.tuia.ecb.center.mix.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ecb.center.mix.dto.financial.MixFinancialConfigDto;

/**
 * [工具类赚钱页]财务模型配置接口
 *
 * @author zhangbaiqiang
 * @date 2020/4/2
 */
@AdvancedFeignClient
public interface RemoteMixFinancialConfigService {

    /**
     * 查询财务模型配置
     *
     * @param slotId 广告位id
     * @return 财务模型配置
     */
    MixFinancialConfigDto queryFinancialConfig(Long slotId) throws BizException;

    /**
     * 保存财务模型配置
     *
     * @param slotId 广告位id
     * @param config 财务模型配置
     */
    void saveFinancialConfig(Long slotId, MixFinancialConfigDto config) throws BizException;
}
