package cn.com.duiba.tuia.ecb.center.mix.dto;

import java.io.Serializable;
import java.util.List;

/**
 * @Author: xianhongwei
 * @Time: 2020-01-11 12:00
 * @Desc:
 */
public class PageDTO<T extends Serializable> extends BaseDto {

    private static final long serialVersionUID = -4614140539293496037L;

    /**
     * 每页数量
     */
    private int pageSize;

    /**
     * 总数.
     */
    private int totalCount;

    /**
     * 总页数.
     */
    private int totalPage;

    /**
     * 当前页
     */
    private int currentPage;

    /**
     * 偏移量
     */
    private int offset;

    /**
     * 每页数量
     */
    private int max;

    /**
     * The data.
     */
    private List<T> list;

    /**
     * 总计数据
     */
    private T total;

    /**
     * Creates a new instance of PageResultDto.
     */
    @SuppressWarnings("unused")
    private PageDTO() {
        super();
    }

    /**
     * Creates a new instance of PageDto.
     *
     * @param totalAmount 总数
     * @param list        数据
     * @param offset      偏移值
     * @param max         页最大数量
     */
    public PageDTO(int totalAmount, List<T> list, int offset, int max) {
        super();
        this.totalCount = totalAmount;
        this.list = list;
        this.offset = offset;
        this.max = max;
        this.pageSize = max;
        this.currentPage = offset / max + 1;
        this.totalPage = calTotalPage(pageSize);
    }

    /**
     * Creates a new instance of PageDto.
     *
     * @param currentPage
     * @param pageSize
     */
    public PageDTO(int currentPage, int pageSize) {
        super();
        this.max = pageSize;
        this.currentPage = currentPage;
        this.pageSize = pageSize;
        this.offset = pageSize * (currentPage - 1);
    }

    /**
     * 设置总页数.
     *
     * @param pageSize 每页记录数
     * @return the int
     */
    private int calTotalPage(int pageSize) {
        if (totalCount < 0) {
            return 0;
        }
        return (totalCount + 1) / pageSize;
    }

    public int getTotalCount() {
        return totalCount;
    }

    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount;
    }

    public List<T> getList() {
        return list;
    }

    public void setList(List<T> list) {
        this.list = list;
    }

    public int getTotalPage() {
        return totalPage;
    }

    public void setTotalPage(int totalPage) {
        this.totalPage = totalPage;
    }

    public int getPageSize() {
        return pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getOffset() {
        return offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getMax() {
        return max;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public T getTotal() {
        return total;
    }

    public void setTotal(T total) {
        this.total = total;
    }

    public int getCurrentPage() {
        return currentPage;
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }
}
