package cn.com.duiba.tuia.ecb.center.mix.req;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * 可以选择对类功能进行说明
 * Created by zxw on 2020-04-26.
 */

@AllArgsConstructor
@NoArgsConstructor
@Data
public class MixNewsConfigReq implements Serializable {

    /**
     * 每日阅读上限
     */
    private Integer readLimit = 50;

    /**
     * 每日阅读前n篇
     */
    private Integer preview = 20;

    /**
     * 翻倍次数上限
     */
    private Integer doubleLimit = 20;

    /**
     * 翻倍出现的概率 [0, 100]
     */
    private Integer doubleRate = 70;

    /**
     * 最低奖励
     */
    private Integer lowest = 6;

    /**
     * 最高奖励
     */
    private Integer highest = 12;
}
