package cn.com.duiba.tuia.ecb.center.seek;

import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;

/**
 * 寻宝活动信息
 * Created by zxw on 2020-09-27.
 */
@Getter
@Setter
@Builder
public class SeekDto implements Serializable {

    @ApiModelProperty("可选商品配置")
    private List<SeekGiftDto> gifts;

    @ApiModelProperty("看视频给的次数")
    private Integer videoTimes;

    @ApiModelProperty("寻宝用户信息")
    private SeekUserInfoDto userInfo;

    @ApiModelProperty("特殊格子的配置")
    private List<CellConfigDto> cells;

    @ApiModelProperty("不看视频给的次数")
    private Integer freeTimes;

}
