package cn.com.duiba.tuia.ecb.center.video.req;

import lombok.Data;

import java.io.Serializable;

/**
 * @author huangruodan
 * @version 创建时间：2020/4/9 5:21 下午
 */
@Data
public class VideoRequestParamReq implements Serializable {

    private static final long serialVersionUID = 3090514404769240542L;
    /**
     * 时间戳
     */
    private Long timestamp;

    /**
     * 用户id（给媒体方）
     */
    private String userId;

    /**
     * ua
     */
    private String ua;

    /**
     * 推啊的系统类型 枚举
     */
    private Integer tuiaOsType;

    /**
     * 系统类型 值根据媒体方给的系统枚举来定
     */
    private Integer osType;

    /**
     * 系统
     */
    private String os;

    /**
     * 手机品牌
     */
    private String brand;

    /**
     * 用户ip
     */
    private String ip;

    /**
     * 手机型号
     */
    private String model;

    /**
     * 像素密度
     */
    private Integer ppi;

    /**
     * 屏幕宽度
     */
    private Integer screenWidth;

    /**
     * 屏幕宽度
     */
    private Integer screenHeight;

    /**
     * 设备类型 详细字符串
     */
    private String device;

    /**
     * 推啊系统类型枚举
     */
    private Integer tuiaDeviceType;

    /**
     * 设备类型 根据媒体的枚举类来确定
     */
    private Integer deviceType;

    /**
     * imei
     */
    private String imei;

    /**
     * oaid
     */
    private String oaid;

    /**
     * 安卓id
     */
    private String androidId;

    /**
     * mac地址
     */
    private String mac;

    /**
     * iOS设备唯一标识码
     */
    private String idfa;

    /**
     * 系统版本号
     */
    private String osVersion;

    /**
     * 设备厂商
     */
    private String vendor;

    private String requestId;

    private String appId;


    /**
     * 基站ID
     */
    private String cellularId;

    /**
     * 纬度
     */
    private String lat;

    /**
     * 经度
     */
    private String lon;

    /**
     * 网络类型: 0- 未知网络 2- 2G 3- 3G 4- 4G 5- 5G 100-WIFI 101—ETHERNET 999--NEW_TYPE
     */
    private Integer connectionType;

    /**
     * 运营商类型: 0- 未知 1- 中国移动 2- 中国电信 3- 中国联通 99-其他运营商
     */
    private Integer operatorType;

    private String appPackageName;

    private String slotId;

    private String appName;

    /**
     * idfv
     */
    private String idfv;

    /**
     * imsi
     */
    private String imsi;

}
