package cn.com.duiba.tuia.ecb.center.draw.remote;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ecb.center.draw.dto.red.RedDrawActivityConfigDTO;
import cn.com.duiba.tuia.ecb.center.draw.dto.red.RedDrawPrizeConfigDTO;

import java.util.List;

/**
 * @ClassName RemoteRedDrawConfigService
 * @Description
 * @Author Zaizai
 * @Date 2020/12/24 2:35 下午
 **/
@AdvancedFeignClient
public interface RemoteRedDrawConfigService {

    /**
     * 保存活动配置
     * @param activityId
     * @param redDrawActivityConfigDTO
     * @return
     */
    Boolean saveOrUpdateBaseConfig(Long activityId, RedDrawActivityConfigDTO redDrawActivityConfigDTO) throws BizException;

    /**
     * 保存奖品配置
     * @param activityId
     * @param redDrawPrizeConfigDTOS
     * @return
     */
    Boolean saveOrUpdatePrizeConfig(Long activityId, List<RedDrawPrizeConfigDTO> redDrawPrizeConfigDTOS) throws BizException;

    /**
     * 查看活动配置
     * @param activityId
     * @return
     */
    RedDrawActivityConfigDTO queryRedDrawActivityConfig(Long activityId);

    /**
     * 查看奖品配置
     * @param activityId
     * @return
     */
    List<RedDrawPrizeConfigDTO> queryRedDrawPrizesConfig(Long activityId);

}
