package cn.com.duiba.tuia.ecb.center.draw.remote;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ecb.center.draw.dto.RedDrawMixUserReq;
import cn.com.duiba.tuia.ecb.center.draw.dto.red.RedDrawBaseUserActivityDTO;
import cn.com.duiba.tuia.ecb.center.draw.dto.red.RedDrawDTO;
import cn.com.duiba.tuia.ecb.center.draw.dto.red.RedDrawLuckResultDTO;
import cn.com.duiba.tuia.ecb.center.draw.dto.red.RedDrawRewardPrizeDTO;

/**
 * @ClassName RemoteRedDrawV2Service
 * @Description
 * @Author Zaizai
 * @Date 2021/2/5 2:19 下午
 **/
@AdvancedFeignClient
public interface RemoteRedDrawV2Service {

    /**
     * 初始化红包抽奖活动
     * @param redDrawMixUserReq
     * @return
     */
    RedDrawDTO initialize(RedDrawMixUserReq redDrawMixUserReq) throws BizException;

    /**
     * 参与抽奖活动
     * @param redDrawMixUserReq
     * @return
     * @throws BizException
     */
    RedDrawLuckResultDTO doJoin(RedDrawMixUserReq redDrawMixUserReq) throws BizException;

    /**
     * 获取激励id
     * @param redDrawMixUserReq
     * @return
     * @throws BizException
     */
    String getRewardId(RedDrawMixUserReq redDrawMixUserReq) throws BizException;

    /**
     * 随机奖励
     * @param redDrawMixUserReq
     * @return
     * @throws BizException
     */
    RedDrawRewardPrizeDTO randomPrize(RedDrawMixUserReq redDrawMixUserReq) throws BizException;

    /**
     * 获取激励奖励
     * @return
     * @throws BizException
     */
    RedDrawRewardPrizeDTO queryRewardPrize(RedDrawMixUserReq redDrawMixUserReq) throws BizException;

    /**
     * 再来一局数据初始化
     * @param redDrawMixUserReq
     * @return
     */
    RedDrawDTO oneMoreGame(RedDrawMixUserReq redDrawMixUserReq) throws BizException;

    /**
     * 获取用户活动信息
     * @param redDrawMixUserReq
     * @return
     * @throws BizException
     */
    RedDrawBaseUserActivityDTO queryRedDrawActivityUser(RedDrawMixUserReq redDrawMixUserReq) throws BizException;

}
