package cn.com.duiba.tuia.ecb.center.mix.enums;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

/**
 * [工具类赚钱页]业务枚举(收益来源)
 *
 * 添加注意事项：
 * 1、type 最高 255
 * 2、随机金币类型的需要添加到 Set 里
 *
 * @author zhangbaiqiang
 * @date 2020/1/11
 */
public enum BusinessType {

    // 1-99 第三方奖励
    // 101-199 激励视频奖励
    // 201-255 特殊奖励
    // 由于数据库限制,最高255，不然会有问题

    UNDEFINED(0, "未定义", null, ""),
    TUIA_FARM(1, "红包农场", null, ""),
    BAOQU_GAME(2, "玩游戏赚钱", null, "玩游戏赚钱"), // 豹趣游戏大厅
    WULI_NEWS(3, "看新闻赚钱", null, "看新闻赚钱"),  // 唔哩内容/瑞狮
    NOVEL(4, "看小说", null, ""),
    MISSION_DDZ_GAME(5, "任务-试玩广告", 3, ""),
    MISSION_WULI_NEWS(6, "任务-看新闻领金币", 1, ""),  // 唔哩内容/瑞狮
    MISSION_BAOQU_GAME(7, "任务-玩游戏领金币", 6, ""), // 豹趣游戏大厅
    MISSION_XIANWAN_GAME(8, "任务-闲玩", 8, ""), // 闲玩
    MISSION_MEDIA__MISSION(9, "任务奖励", 101, ""), // 第三方奖励-媒体任务 condition实际值 101-109
    WULI_VIDEO(10, "看视频新闻奖励", null, "看视频新闻奖励"), // 唔哩头条视频

    MISSION_REWARD_ACTIVITY(101, "任务-参与活动领金币", 5, ""), // 激励互动
    MISSION_REWARD_VIDEO(102, "任务-看视频领金币", 4, ""),      // 激励视频
    CASH_COW_DOUBLE(103, "摇钱树翻倍", null, "翻倍成功"),
    SIGN_IN_REPLENISH(104, "签到补签", null, "补签成功"),
    SIGN_IN_DOUBLE(105, "签到翻倍", null, "翻倍成功"),
    MISSION_NATIVE(106, "任务-插屏互动", 7, ""), // 插屏互动
    LOTTERY_CAPTURE(107, "彩票领取", null, ""), // 彩票领取
    MISSION_WULI_VIDEO(108, "看视频新闻奖励", MissionConditionType.WULI_VIDEO.getType(), "看视频新闻奖励"), // 唔哩头条视频
    MISSION_READ_NEWS(109, "任务-阅读新闻", MissionConditionType.READ_NEWS.getType(), "阅读新闻任务"), // 阅读新闻任务
    MISSION_DIANHUN_GAME(110, "任务-电魂游戏", MissionConditionType.DIANHUN_GAME.getType(), "电魂游戏任务"), // 电魂游戏任务


    NEW_GIFT(201, "新手礼包", null, ""),
    SIGN_IN(202, "签到", null, "签到成功"),
    EXCHANGE(203, "金币兑换现金", null, ""),
    CASH_COW_FRUIT(204, "摇钱树果实奖励", null, "收取成功"),
    CASH_COW_CLOSE(205, "摘果实关闭弹窗", null, ""),
    READ_NEWS(206, "阅读新闻", null, "看新闻赚钱"),
    READ_NEWS_DOUBLE(207, "阅读新闻翻倍", null, "看新闻赚钱翻倍"),
    CLOCK_SIGN_UP(208, "早起打卡报名", null, "报名成功"),
    CLOCK_GET_GOLD(209, "早起打卡奖励", null, "打卡奖励"),
    ;

    /**
     * 业务类型
     */
    private Integer type;
    /**
     * 业务描述
     */
    private String desc;
    /**
     * 关联的任务条件类型
     */
    private Integer missionConditionType;
    /**
     * 奖励文案
     */
    private String prizeText;

    // 业务类型-业务枚举映射
    private static final HashMap<Integer, BusinessType> businessMap = new HashMap<>(values().length);

    // 属于随机金币的业务类型集合
    private static final Set<Integer> randomIncomeBusinessTypeSet = new HashSet<>();

    static {
        for (BusinessType e : BusinessType.values()){
            businessMap.put(e.getType(), e);
        }

        // 更新时，属于随机金币类型的都要在这里添加，用于财务模型计算
        randomIncomeBusinessTypeSet.add(BAOQU_GAME.getType());
        randomIncomeBusinessTypeSet.add(WULI_NEWS.getType());
        randomIncomeBusinessTypeSet.add(WULI_VIDEO.getType());
        randomIncomeBusinessTypeSet.add(NOVEL.getType());
        randomIncomeBusinessTypeSet.add(CASH_COW_DOUBLE.getType());
        randomIncomeBusinessTypeSet.add(CASH_COW_FRUIT.getType());
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getMissionConditionType() {
        return missionConditionType;
    }

    public String getPrizeText() {
        return prizeText;
    }

    BusinessType(Integer type, String desc, Integer missionConditionType, String prizeText) {
        this.type = type;
        this.desc = desc;
        this.missionConditionType = missionConditionType;
        this.prizeText = prizeText;
    }

    /**
     * 查询业务类型对应的业务枚举
     */
    public static BusinessType getEnum(Integer businessType) {
        if (null == businessType) {
            return null;
        }
        return businessMap.get(businessType);
    }

    /**
     * 判断是否属于任务的业务类型
     *
     * @return true.是, false.否
     */
    public boolean isMission() {
        return null != this.missionConditionType;
    }

    /**
     * 判断是否属于随机金币的业务类型
     *
     * @param businessType 业务类型
     * @return true.是, false.否
     */
    public static boolean isRandomIncome(Integer businessType) {
        return null != businessType && randomIncomeBusinessTypeSet.add(businessType);
    }
}
