package cn.com.duiba.tuia.ecb.center.video.enums.third;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * @author huangruodan
 * @version 创建时间：2020/4/10 10:48 上午
 */
public enum ThirdXgDeviceType {

    MOBILE(1, 1, "PHONE"),
    PAD(2, 2, "TABLET");

    private Integer tuiaType;

    private Integer type;

    private String desc;

    private  static  Map<Integer, ThirdXgDeviceType> deviceTypeMap = Maps.newHashMap();

    static {
        deviceTypeMap.put(MOBILE.getTuiaType(), MOBILE);
        deviceTypeMap.put(PAD.getTuiaType(), PAD);
    }

    ThirdXgDeviceType(Integer tuiaType, Integer type, String desc) {
        this.tuiaType = tuiaType;
        this.type = type;
        this.desc = desc;
    }

    public Integer getTuiaType() {
        return tuiaType;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }


}
